% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.R
\name{add_p.tbl_summary}
\alias{add_p.tbl_summary}
\title{Add p-values}
\usage{
\method{add_p}{tbl_summary}(
  x,
  test = NULL,
  pvalue_fun = label_style_pvalue(digits = 1),
  group = NULL,
  include = everything(),
  test.args = NULL,
  adj.vars = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
table created with \code{tbl_summary()}}

\item{test}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the statistical tests to perform for each variable, e.g.
\code{list(all_continuous() ~ "t.test", all_categorical() ~ "fisher.test")}.

See below for details on default tests and \link[=tests]{?tests} for details on available
tests and creating custom tests.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{group}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable name of an ID or grouping variable. The column can be used to
calculate p-values with correlated data.
Default is \code{NULL}. See \link{tests} for methods that utilize the \code{group} argument.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{test.args}{(\code{\link[=syntax]{formula-list-selector}})\cr
Containing additional arguments to pass to tests that accept arguments.
For example, add an argument for all t-tests, use
\code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}.}

\item{adj.vars}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in adjusted calculations (e.g. in ANCOVA models).
Default is \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table of class \code{"tbl_summary"}
}
\description{
Adds p-values to tables created by \code{\link[=tbl_summary]{tbl_summary()}} by comparing values across groups.
}
\section{test argument}{


See the \link[=tests]{?tests} help file for details on available tests and creating custom tests.
The \link[=tests]{?tests} help file also includes psuedo-code for each test to be clear
precisely how the calculation is performed.

The default test used in \code{add_p()} primarily depends on these factors:
\itemize{
\item whether the variable is categorical/dichotomous vs continuous
\item number of levels in the \code{tbl_summary(by)} variable
\item whether the \code{add_p(group)} argument is specified
\item whether the \code{add_p(adj.vars)} argument is specified
}
\subsection{Specified neither \code{add_p(group)} nor \code{add_p(adj.vars)}}{
\itemize{
\item \code{"wilcox.test"} when \code{by} variable has two levels and variable is continuous.
\item \code{"krustkal.test"} when \code{by} variable has more than two levels and variable is continuous.
\item \code{"chisq.test.no.correct"} for categorical variables with all expected cell counts >=5,
and \code{"fisher.test"} for categorical variables with any expected cell count <5.
}
}

\subsection{Specified \code{add_p(group)} and not \code{add_p(adj.vars)}}{
\itemize{
\item \code{"lme4"} when \code{by} variable has two levels for all summary types.
}

\emph{There is no default for grouped data when \code{by} variable has more than two levels.}
\emph{Users must create custom tests for this scenario.}
}

\subsection{Specified \code{add_p(adj.vars)} and not \code{add_p(group)}}{
\itemize{
\item \code{"ancova"} when variable is continuous and \code{by} variable has two levels.
}
}
}

\examples{
\dontshow{if (gtsummary:::is_pkg_installed("cardx", reference_pkg = "gtsummary") && gtsummary:::is_pkg_installed("broom", reference_pkg = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  tbl_summary(by = trt, include = c(age, grade)) |>
  add_p()

# Example 2 ----------------------------------
trial |>
  select(trt, age, marker) |>
  tbl_summary(by = trt, missing = "no") |>
  add_p(
    # perform t-test for all variables
    test = everything() ~ "t.test",
    # assume equal variance in the t-test
    test.args = all_tests("t.test") ~ list(var.equal = TRUE)
  )
\dontshow{\}) # examplesIf}
}
