% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_cross.R
\name{tbl_cross}
\alias{tbl_cross}
\title{Cross table}
\usage{
tbl_cross(
  data,
  row = 1L,
  col = 2L,
  label = NULL,
  statistic = ifelse(percent == "none", "{n}", "{n} ({p}\%)"),
  digits = NULL,
  percent = c("none", "column", "row", "cell"),
  margin = c("column", "row"),
  missing = c("ifany", "always", "no"),
  missing_text = "Unknown",
  margin_text = "Total"
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{row}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Column name in \code{data} to be used for the rows of cross table.
Default is the first column in \code{data}.}

\item{col}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Column name in \code{data} to be used for the columns of cross table.
Default is the second column in \code{data}.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{statistic}{(\code{string})\cr
A string with the statistic name in curly brackets to
be replaced with the numeric statistic (see glue::glue).
The default is \code{{n}}. If percent argument is \code{"column"}, \code{"row"}, or \code{"cell"},
default is \code{"{n} ({p}\%)"}.}

\item{digits}{(\code{numeric}/\code{list}/\code{function})\cr
Specifies the number of decimal
places to round the summary statistics.
This argument is passed to \code{tbl_summary(digits = ~digits)}.
By default integers are shown
to the zero decimal places, and percentages are formatted with \code{style_percent()}.
If you would like to modify either of these, pass a vector of integers
indicating the number of decimal places to round the statistics.
For example, if the
statistic being calculated is \code{"{n} ({p}\%)"} and you want the percent rounded
to 2 decimal places use \code{digits = c(0, 2)}. User
may also pass a styling function: \code{digits = style_sigfig}}

\item{percent}{(\code{string})\cr
Indicates the type of percentage to return.
Must be one of "none", "column", "row", or "cell". Default is "cell" when
\code{{N}} or \code{{p}} is used in statistic.}

\item{margin}{(\code{character})\cr
Indicates which margins to add to the table.
Default is \code{c("row", "column")}. Use \code{margin  = NULL} to suppress both
row and column margins.}

\item{missing}{(\code{string})\cr
Must be one of \code{c("ifany", "no", "always")}.}

\item{missing_text}{(\code{string})\cr
String indicating text shown on missing row. Default is \code{"Unknown"}}

\item{margin_text}{(\code{string})\cr
Text to display for margin totals. Default is \code{"Total"}}
}
\value{
A \code{tbl_cross} object
}
\description{
The function creates a cross table of categorical variables.
}
\examples{
# Example 1 ----------------------------------
trial |>
  tbl_cross(row = trt, col = response) |>
  bold_labels()

# Example 2 ----------------------------------
trial |>
  tbl_cross(row = stage, col = trt, percent = "cell") |>
  add_p() |>
  bold_labels()
}
\author{
Karissa Whiting, Daniel D. Sjoberg
}
