% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_preserve_sum.R
\name{round_preserve_sum}
\alias{round_preserve_sum}
\title{Round values while preserve their rounded sum in R}
\source{
\url{https://biostatmatt.com/archives/2902}
}
\usage{
round_preserve_sum(x, digits = 0)
}
\arguments{
\item{x}{Numerical vector to sum.}

\item{digits}{Number of decimals for rounding.}
}
\value{
A numerical vector of same length as \code{x}.
}
\description{
Sometimes, the sum of rounded numbers (e.g., using \code{\link[base:Round]{base::round()}}) is not
the same as their rounded sum.
}
\details{
This solution applies the following algorithm
\itemize{
\item Round down to the specified number of decimal places
\item Order numbers by their remainder values
\item Increment the specified decimal place of values with \emph{k} largest
remainders, where \emph{k} is the number of values that must be incremented to
preserve their rounded sum
}
}
\examples{
sum(c(0.333, 0.333, 0.334))
round(c(0.333, 0.333, 0.334), 2)
sum(round(c(0.333, 0.333, 0.334), 2))
round_preserve_sum(c(0.333, 0.333, 0.334), 2)
sum(round_preserve_sum(c(0.333, 0.333, 0.334), 2))
}
\keyword{univar}
