% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gss_gwbr.R
\name{gss_gwbr}
\alias{gss_gwbr}
\title{Golden Section Search Algorithm}
\usage{
gss_gwbr(
  yvar,
  xvar,
  lat,
  long,
  data,
  method = c("fixed_g", "fixed_bsq", "adaptive_bsq"),
  link = c("logit", "probit", "loglog", "cloglog"),
  type = c("cv", "aic"),
  globalmin = TRUE,
  distancekm = TRUE,
  maxint = 100
)
}
\arguments{
\item{yvar}{A vector with the response variable name.}

\item{xvar}{A vector with descriptive variable(s) name(s).}

\item{lat}{A vector with the latitude variable name.}

\item{long}{A vector with the longitude variable name.}

\item{data}{A data set object with \code{yvar} and \code{xvar}.}

\item{method}{Kernel function used to set bandwidth parameter. The options are: \code{"fixed_g"}, \code{"fixed_bsq"} or \code{"adaptive_bsq"}. The default is \code{"fixed_g"}.}

\item{link}{The link function used in modeling. The options are: \code{"logit"}, \code{"probit"}, \code{"loglog"} or \code{"cloglog"}. The default is \code{"logit"}.}

\item{type}{Can be \code{"cv"}, when the Cross-Validation function is used to estimate the bandwidth or \code{"aic"}, when the AIC function is used. The default is \code{"cv"}.}

\item{globalmin}{Logical. If \code{TRUE} search for the global minimum. The default is \code{TRUE}.}

\item{distancekm}{Logical. If \code{TRUE} use the distance in kilometers otherwise, use the Euclidean distance. The default is \code{TRUE}.}

\item{maxint}{A maximum number of iterations to numerically maximize the log-likelihood function in search of parameter estimates. The default is \code{maxint=100}.}
}
\value{
A list that contains:

\itemize{
\item \code{global_min} - Global minimum of the function, giving the best bandwidth (\code{h}).
\item \code{local_mins} - Local minimums of the function.
\item \code{type} - Function used to estimate the bandwidth.
}
}
\description{
The Golden Section Search (GSS) algorithm is used in searching for the best bandwidth for geographically weighted regression. For more details see Da Silva and Mendes (2018).
}
\examples{
\donttest{
data(saopaulo)
output_list=gss_gwbr("prop_landline",c("prop_urb","prop_poor"),"y","x",saopaulo,"fixed_g")

## Best bandwidth
output_list$global_min
}
}
