% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.elliptical.R
\name{summary.elliptical}
\alias{summary.elliptical}
\title{Summarizing Elliptical Model Fits.}
\usage{
\method{summary}{elliptical}(object, correlation = TRUE, ...)
}
\arguments{
\item{object}{fit object for elliptical regression model.}

\item{correlation}{if TRUE, the correlation matrix of the estimated parameters is returned and printed.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \code{summary.elliptical}, a list with components: 
\item{coefficients}{the matrix of coefficients, standard errors and significance values for hypothesis test.}
\item{dispersion}{either the supplied argument or the estimated dispersion with standard error.}
\item{residuals}{residuals from \code{object}.}
\item{cov.unscaled}{the unscaled (dispersion = 1) estimated covariance matrix of the estimated coefficients.}
\item{corrrelation}{the likelihood logarithm value of the adjusted model's.}  
\item{family}{family from \code{object}.}
\item{loglik}{logarithmic likelihood from \code{object}.}
\item{terms}{the \code{terms} object used.}
\item{df}{degrees of fredom  from \code{object}.}
\item{inter}{the number of iterations of optimization process from \code{object}.}
\item{nas}{a logical vector indicating if there is \code{na} in estimation of coefficients.}
\item{call}{the matched call from \code{object}.}
\item{scale}{the values of the 4d_g for the specified distribution from \code{object}.}
\item{scaledispersion}{the values of the 4f_g for the specified distribution from \code{object}.}
}
\description{
These functions are all methods for class \code{glm} or \code{summary.glm} objects.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5)
,data=luz)
summary(elliptical.fitt)
}
\references{
Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\url{https://doi.org/10.1016/j.spl.2007.01.012}
}
\seealso{
\code{\link{glm}}, \code{\link{elliptical}}, \code{\link{elliptical.diag}}
}
\keyword{elliptical}
\keyword{summary}
