% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\name{gyrosegment}
\alias{gyrosegment}
\title{Gyrosegment}
\usage{
gyrosegment(A, B, s = 1, n = 100)
}
\arguments{
\item{A, B}{two distinct points (of the same dimension)}

\item{s}{positive number, the curvature}

\item{n}{number of points forming the gyrosegment from \code{A} to \code{B}}
}
\value{
A numeric matrix with \code{n} rows. Each row is a point on the
  gyrosegment from \code{A} (the first row) to \code{B} (the last row).
}
\description{
Gyrosegment joining two given points.
}
\examples{
library(gyro)
# a 2D example ####
A <- c(1, 2); B <- c(1, 1)
plot(rbind(A, B), type = "p", pch = 19, xlab = NA, ylab = NA,
     xlim = c(0, 2), ylim = c(0, 2), asp = 1)
AB <- gyrosegment(A, B, s = 0.2)
lines(AB) # this is a piece of an hyperboloid
text(t(A), expression(italic(A)), pos = 1)
text(t(B), expression(italic(B)), pos = 3)

# a 3D hyperbolic triangle
library(rgl)
A <- c(1, 0, 0); B <- c(0, 1, 0); C <- c(0, 0, 1)
s <- 0.3
AB <- gyrosegment(A, B, s)
AC <- gyrosegment(A, C, s)
BC <- gyrosegment(B, C, s)
view3d(30, 30, zoom = 0.75)
lines3d(AB, lwd = 3); lines3d(AC, lwd = 3); lines3d(BC, lwd = 3)
}
