% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/models.R
\name{predict.H2OModel}
\alias{h2o.predict}
\alias{predict.H2OModel}
\title{Predict on an H2O Model}
\usage{
\method{predict}{H2OModel}(object, newdata, ...)

h2o.predict(object, newdata, ...)
}
\arguments{
\item{object}{a fitted \linkS4class{H2OModel} object for which prediction is
desired}

\item{newdata}{An H2OFrame object in which to look for
variables with which to predict.}

\item{...}{additional arguments to pass on.}
}
\value{
Returns an H2OFrame object with probabilites and
        default predictions.
}
\description{
Obtains predictions from various fitted H2O model objects.
}
\details{
This method dispatches on the type of H2O model to select the correct
prediction/scoring algorithm.
The order of the rows in the results is the same as the order in which the
data was loaded, even if some rows fail (for example, due to missing
values or unseen factor levels).
}
\seealso{
\code{\link{h2o.deeplearning}}, \code{\link{h2o.gbm}},
         \code{\link{h2o.glm}}, \code{\link{h2o.randomForest}} for model
         generation in h2o.
}

