% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.length}
\alias{h2o.length}
\alias{length,H2OFrame-method}
\title{Returns the Length of a Parsed H2O Data Object.}
\usage{
h2o.length(x)

\S4method{length}{H2OFrame}(x)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}
}
\description{
Returns the length of an \code{\linkS4class{H2OFrame}}
}
\examples{
\donttest{
localH2O <- h2o.init()
irisPath <- system.file("extdata", "iris.csv", package = "h2o")
iris.hex <- h2o.uploadFile(localH2O, path = irisPath)
length(iris.hex)
}
}
\seealso{
\code{\link[base]{length}} for the base R method.
}

