# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- Deep Learning - Neural Network -------------------------- #
#' 
#' Build a Deep Neural Network model using CPUs
#' 
#' Builds a feed-forward multilayer artificial neural network on an H2OFrame.
#' 
#' @param x (Optional) A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except y are used.
#' @param y The name or column index of the response variable in the data. The response must be either a numeric or a
#'        categorical/factor variable. If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param training_frame Id of the training data frame.
#' @param validation_frame Id of the validation data frame.
#' @param nfolds Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.
#' @param keep_cross_validation_predictions \code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.
#' @param keep_cross_validation_fold_assignment \code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.
#' @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
#'        stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
#'        "Random", "Modulo", "Stratified". Defaults to AUTO.
#' @param fold_column Column with cross-validation fold index assignment per observation.
#' @param ignore_const_cols \code{Logical}. Ignore constant columns. Defaults to TRUE.
#' @param score_each_iteration \code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.
#' @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
#'        the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
#'        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
#'        data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
#'        well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.
#' @param offset_column Offset column. This will be added to the combination of columns before applying the link function.
#' @param balance_classes \code{Logical}. Balance training data class counts via over/under-sampling (for imbalanced data). Defaults to
#'        FALSE.
#' @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
#'        be automatically computed to obtain class balance during training. Requires balance_classes.
#' @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
#'        balance_classes. Defaults to 5.0.
#' @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable).
#'        Defaults to 0.
#' @param checkpoint Model checkpoint to resume training with.
#' @param pretrained_autoencoder Pretrained autoencoder model to initialize this model with.
#' @param overwrite_with_best_model \code{Logical}. If enabled, override the final model with the best model found during training. Defaults to
#'        TRUE.
#' @param use_all_factor_levels \code{Logical}. Use all factor levels of categorical variables. Otherwise, the first factor level is omitted
#'        (without loss of accuracy). Useful for variable importances and auto-enabled for autoencoder. Defaults to
#'        TRUE.
#' @param standardize \code{Logical}. If enabled, automatically standardize the data. If disabled, the user must provide properly
#'        scaled input data. Defaults to TRUE.
#' @param activation Activation function. Must be one of: "Tanh", "TanhWithDropout", "Rectifier", "RectifierWithDropout", "Maxout",
#'        "MaxoutWithDropout". Defaults to Rectifier.
#' @param hidden Hidden layer sizes (e.g. [100, 100]). Defaults to [200, 200].
#' @param epochs How many times the dataset should be iterated (streamed), can be fractional. Defaults to 10.
#' @param train_samples_per_iteration Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all
#'        available data (e.g., replicated training data), -2: automatic. Defaults to -2.
#' @param target_ratio_comm_to_comp Target ratio of communication overhead to computation. Only for multi-node operation and
#'        train_samples_per_iteration = -2 (auto-tuning). Defaults to 0.05.
#' @param seed Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
#'        Note: only reproducible when running single threaded.
#'        Defaults to -1 (time-based random number).
#' @param adaptive_rate \code{Logical}. Adaptive learning rate. Defaults to TRUE.
#' @param rho Adaptive learning rate time decay factor (similarity to prior updates). Defaults to 0.99.
#' @param epsilon Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress). Defaults to 1e-08.
#' @param rate Learning rate (higher => less stable, lower => slower convergence). Defaults to 0.005.
#' @param rate_annealing Learning rate annealing: rate / (1 + rate_annealing * samples). Defaults to 1e-06.
#' @param rate_decay Learning rate decay factor between layers (N-th layer: rate * rate_decay ^ (n - 1). Defaults to 1.
#' @param momentum_start Initial momentum at the beginning of training (try 0.5). Defaults to 0.
#' @param momentum_ramp Number of training samples for which momentum increases. Defaults to 1000000.
#' @param momentum_stable Final momentum after the ramp is over (try 0.99). Defaults to 0.
#' @param nesterov_accelerated_gradient \code{Logical}. Use Nesterov accelerated gradient (recommended). Defaults to TRUE.
#' @param input_dropout_ratio Input layer dropout ratio (can improve generalization, try 0.1 or 0.2). Defaults to 0.
#' @param hidden_dropout_ratios Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5.
#' @param l1 L1 regularization (can add stability and improve generalization, causes many weights to become 0). Defaults to
#'        0.
#' @param l2 L2 regularization (can add stability and improve generalization, causes many weights to be small. Defaults to
#'        0.
#' @param max_w2 Constraint for squared sum of incoming weights per unit (e.g. for Rectifier). Defaults to 3.4028235e+38.
#' @param initial_weight_distribution Initial weight distribution. Must be one of: "UniformAdaptive", "Uniform", "Normal". Defaults to
#'        UniformAdaptive.
#' @param initial_weight_scale Uniform: -value...value, Normal: stddev. Defaults to 1.
#' @param initial_weights A list of H2OFrame ids to initialize the weight matrices of this model with.
#' @param initial_biases A list of H2OFrame ids to initialize the bias vectors of this model with.
#' @param loss Loss function. Must be one of: "Automatic", "CrossEntropy", "Quadratic", "Huber", "Absolute", "Quantile".
#'        Defaults to Automatic.
#' @param distribution Distribution function Must be one of: "AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma",
#'        "tweedie", "laplace", "quantile", "huber". Defaults to AUTO.
#' @param quantile_alpha Desired quantile for Quantile regression, must be between 0 and 1. Defaults to 0.5.
#' @param tweedie_power Tweedie power for Tweedie regression, must be between 1 and 2. Defaults to 1.5.
#' @param huber_alpha Desired quantile for Huber/M-regression (threshold between quadratic and linear loss, must be between 0 and
#'        1). Defaults to 0.9.
#' @param score_interval Shortest time interval (in seconds) between model scoring. Defaults to 5.
#' @param score_training_samples Number of training set samples for scoring (0 for all). Defaults to 10000.
#' @param score_validation_samples Number of validation set samples for scoring (0 for all). Defaults to 0.
#' @param score_duty_cycle Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring). Defaults to 0.1.
#' @param classification_stop Stopping criterion for classification error fraction on training data (-1 to disable). Defaults to 0.
#' @param regression_stop Stopping criterion for regression error (MSE) on training data (-1 to disable). Defaults to 1e-06.
#' @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
#'        stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 5.
#' @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) Must be one of:
#'        "AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification",
#'        "mean_per_class_error". Defaults to AUTO.
#' @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
#'        much) Defaults to 0.
#' @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.
#' @param score_validation_sampling Method used to sample validation dataset for scoring. Must be one of: "Uniform", "Stratified". Defaults to
#'        Uniform.
#' @param diagnostics \code{Logical}. Enable diagnostics for hidden layers. Defaults to TRUE.
#' @param fast_mode \code{Logical}. Enable fast mode (minor approximation in back-propagation). Defaults to TRUE.
#' @param force_load_balance \code{Logical}. Force extra load balancing to increase training speed for small datasets (to keep all cores
#'        busy). Defaults to TRUE.
#' @param variable_importances \code{Logical}. Compute variable importances for input features (Gedeon method) - can be slow for large
#'        networks. Defaults to TRUE.
#' @param replicate_training_data \code{Logical}. Replicate the entire training dataset onto every node for faster training on small datasets.
#'        Defaults to TRUE.
#' @param single_node_mode \code{Logical}. Run on a single node for fine-tuning of model parameters. Defaults to FALSE.
#' @param shuffle_training_data \code{Logical}. Enable shuffling of training data (recommended if training data is replicated and
#'        train_samples_per_iteration is close to #nodes x #rows, of if using balance_classes). Defaults to FALSE.
#' @param missing_values_handling Handling of missing values. Either MeanImputation or Skip. Must be one of: "MeanImputation", "Skip". Defaults
#'        to MeanImputation.
#' @param quiet_mode \code{Logical}. Enable quiet mode for less output to standard output. Defaults to FALSE.
#' @param autoencoder \code{Logical}. Auto-Encoder. Defaults to FALSE.
#' @param sparse \code{Logical}. Sparse data handling (more efficient for data with lots of 0 values). Defaults to FALSE.
#' @param col_major \code{Logical}. #DEPRECATED Use a column major weight matrix for input layer. Can speed up forward
#'        propagation, but might slow down backpropagation. Defaults to FALSE.
#' @param average_activation Average activation for sparse auto-encoder. #Experimental Defaults to 0.
#' @param sparsity_beta Sparsity regularization. #Experimental Defaults to 0.
#' @param max_categorical_features Max. number of categorical features, enforced via hashing. #Experimental Defaults to 2147483647.
#' @param reproducible \code{Logical}. Force reproducibility on small data (will be slow - only uses 1 thread). Defaults to FALSE.
#' @param export_weights_and_biases \code{Logical}. Whether to export Neural Network weights and biases to H2O Frames. Defaults to FALSE.
#' @param mini_batch_size Mini-batch size (smaller leads to better fit, larger can speed up and generalize better). Defaults to 1.
#' @param categorical_encoding Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
#'        "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.
#' @param elastic_averaging \code{Logical}. Elastic averaging between compute nodes can improve distributed model convergence.
#'        #Experimental Defaults to FALSE.
#' @param elastic_averaging_moving_rate Elastic averaging moving rate (only if elastic averaging is enabled). Defaults to 0.9.
#' @param elastic_averaging_regularization Elastic averaging regularization strength (only if elastic averaging is enabled). Defaults to 0.001.
#' @param verbose \code{Logical}. Print scoring history to the console (Metrics per tree for GBM, DRF, & XGBoost. Metrics per epoch for Deep Learning). Defaults to FALSE.
#' @seealso \code{\link{predict.H2OModel}} for prediction
#' @examples
#' \donttest{
#' library(h2o)
#' h2o.init()
#' iris.hex <- as.h2o(iris)
#' iris.dl <- h2o.deeplearning(x = 1:4, y = 5, training_frame = iris.hex, seed=123456)
#' 
#' # now make a prediction
#' predictions <- h2o.predict(iris.dl, iris.hex)
#' }
#' @export
h2o.deeplearning <- function(x, y, training_frame,
                             model_id = NULL,
                             validation_frame = NULL,
                             nfolds = 0,
                             keep_cross_validation_predictions = FALSE,
                             keep_cross_validation_fold_assignment = FALSE,
                             fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
                             fold_column = NULL,
                             ignore_const_cols = TRUE,
                             score_each_iteration = FALSE,
                             weights_column = NULL,
                             offset_column = NULL,
                             balance_classes = FALSE,
                             class_sampling_factors = NULL,
                             max_after_balance_size = 5.0,
                             max_hit_ratio_k = 0,
                             checkpoint = NULL,
                             pretrained_autoencoder = NULL,
                             overwrite_with_best_model = TRUE,
                             use_all_factor_levels = TRUE,
                             standardize = TRUE,
                             activation = c("Tanh", "TanhWithDropout", "Rectifier", "RectifierWithDropout", "Maxout", "MaxoutWithDropout"),
                             hidden = c(200, 200),
                             epochs = 10,
                             train_samples_per_iteration = -2,
                             target_ratio_comm_to_comp = 0.05,
                             seed = -1,
                             adaptive_rate = TRUE,
                             rho = 0.99,
                             epsilon = 1e-08,
                             rate = 0.005,
                             rate_annealing = 1e-06,
                             rate_decay = 1,
                             momentum_start = 0,
                             momentum_ramp = 1000000,
                             momentum_stable = 0,
                             nesterov_accelerated_gradient = TRUE,
                             input_dropout_ratio = 0,
                             hidden_dropout_ratios = NULL,
                             l1 = 0,
                             l2 = 0,
                             max_w2 = 3.4028235e+38,
                             initial_weight_distribution = c("UniformAdaptive", "Uniform", "Normal"),
                             initial_weight_scale = 1,
                             initial_weights = NULL,
                             initial_biases = NULL,
                             loss = c("Automatic", "CrossEntropy", "Quadratic", "Huber", "Absolute", "Quantile"),
                             distribution = c("AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma", "tweedie", "laplace", "quantile", "huber"),
                             quantile_alpha = 0.5,
                             tweedie_power = 1.5,
                             huber_alpha = 0.9,
                             score_interval = 5,
                             score_training_samples = 10000,
                             score_validation_samples = 0,
                             score_duty_cycle = 0.1,
                             classification_stop = 0,
                             regression_stop = 1e-06,
                             stopping_rounds = 5,
                             stopping_metric = c("AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "lift_top_group", "misclassification", "mean_per_class_error"),
                             stopping_tolerance = 0,
                             max_runtime_secs = 0,
                             score_validation_sampling = c("Uniform", "Stratified"),
                             diagnostics = TRUE,
                             fast_mode = TRUE,
                             force_load_balance = TRUE,
                             variable_importances = TRUE,
                             replicate_training_data = TRUE,
                             single_node_mode = FALSE,
                             shuffle_training_data = FALSE,
                             missing_values_handling = c("MeanImputation", "Skip"),
                             quiet_mode = FALSE,
                             autoencoder = FALSE,
                             sparse = FALSE,
                             col_major = FALSE,
                             average_activation = 0,
                             sparsity_beta = 0,
                             max_categorical_features = 2147483647,
                             reproducible = FALSE,
                             export_weights_and_biases = FALSE,
                             mini_batch_size = 1,
                             categorical_encoding = c("AUTO", "Enum", "OneHotInternal", "OneHotExplicit", "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited"),
                             elastic_averaging = FALSE,
                             elastic_averaging_moving_rate = 0.9,
                             elastic_averaging_regularization = 0.001,
                             verbose = FALSE 
                             ) 
{
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Required args: training_frame
  if (missing(training_frame)) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Validation_frame must be a key or an H2OFrame object
  if (!is.null(validation_frame)) {
     if (!is.H2OFrame(validation_frame))
         tryCatch(validation_frame <- h2o.getFrame(validation_frame),
             error = function(err) {
                 stop("argument 'validation_frame' must be a valid H2OFrame or key")
             })
  }
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y, autoencoder)
  if( !missing(offset_column) && !is.null(offset_column))  args$x_ignore <- args$x_ignore[!( offset_column == args$x_ignore )]
  if( !missing(weights_column) && !is.null(weights_column)) args$x_ignore <- args$x_ignore[!( weights_column == args$x_ignore )]
  if( !missing(fold_column) && !is.null(fold_column)) args$x_ignore <- args$x_ignore[!( fold_column == args$x_ignore )]
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y

  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(nfolds))
    parms$nfolds <- nfolds
  if (!missing(keep_cross_validation_predictions))
    parms$keep_cross_validation_predictions <- keep_cross_validation_predictions
  if (!missing(keep_cross_validation_fold_assignment))
    parms$keep_cross_validation_fold_assignment <- keep_cross_validation_fold_assignment
  if (!missing(fold_assignment))
    parms$fold_assignment <- fold_assignment
  if (!missing(fold_column))
    parms$fold_column <- fold_column
  if (!missing(ignore_const_cols))
    parms$ignore_const_cols <- ignore_const_cols
  if (!missing(score_each_iteration))
    parms$score_each_iteration <- score_each_iteration
  if (!missing(weights_column))
    parms$weights_column <- weights_column
  if (!missing(offset_column))
    parms$offset_column <- offset_column
  if (!missing(balance_classes))
    parms$balance_classes <- balance_classes
  if (!missing(class_sampling_factors))
    parms$class_sampling_factors <- class_sampling_factors
  if (!missing(max_after_balance_size))
    parms$max_after_balance_size <- max_after_balance_size
  if (!missing(max_hit_ratio_k))
    parms$max_hit_ratio_k <- max_hit_ratio_k
  if (!missing(checkpoint))
    parms$checkpoint <- checkpoint
  if (!missing(pretrained_autoencoder))
    parms$pretrained_autoencoder <- pretrained_autoencoder
  if (!missing(overwrite_with_best_model))
    parms$overwrite_with_best_model <- overwrite_with_best_model
  if (!missing(use_all_factor_levels))
    parms$use_all_factor_levels <- use_all_factor_levels
  if (!missing(standardize))
    parms$standardize <- standardize
  if (!missing(activation))
    parms$activation <- activation
  if (!missing(hidden))
    parms$hidden <- hidden
  if (!missing(epochs))
    parms$epochs <- epochs
  if (!missing(train_samples_per_iteration))
    parms$train_samples_per_iteration <- train_samples_per_iteration
  if (!missing(target_ratio_comm_to_comp))
    parms$target_ratio_comm_to_comp <- target_ratio_comm_to_comp
  if (!missing(seed))
    parms$seed <- seed
  if (!missing(adaptive_rate))
    parms$adaptive_rate <- adaptive_rate
  if (!missing(rho))
    parms$rho <- rho
  if (!missing(epsilon))
    parms$epsilon <- epsilon
  if (!missing(rate))
    parms$rate <- rate
  if (!missing(rate_annealing))
    parms$rate_annealing <- rate_annealing
  if (!missing(rate_decay))
    parms$rate_decay <- rate_decay
  if (!missing(momentum_start))
    parms$momentum_start <- momentum_start
  if (!missing(momentum_ramp))
    parms$momentum_ramp <- momentum_ramp
  if (!missing(momentum_stable))
    parms$momentum_stable <- momentum_stable
  if (!missing(nesterov_accelerated_gradient))
    parms$nesterov_accelerated_gradient <- nesterov_accelerated_gradient
  if (!missing(input_dropout_ratio))
    parms$input_dropout_ratio <- input_dropout_ratio
  if (!missing(hidden_dropout_ratios))
    parms$hidden_dropout_ratios <- hidden_dropout_ratios
  if (!missing(l1))
    parms$l1 <- l1
  if (!missing(l2))
    parms$l2 <- l2
  if (!missing(max_w2))
    parms$max_w2 <- max_w2
  if (!missing(initial_weight_distribution))
    parms$initial_weight_distribution <- initial_weight_distribution
  if (!missing(initial_weight_scale))
    parms$initial_weight_scale <- initial_weight_scale
  if (!missing(initial_weights))
    parms$initial_weights <- initial_weights
  if (!missing(initial_biases))
    parms$initial_biases <- initial_biases
  if(!missing(loss)) {
    if(loss == "MeanSquare") {
      warning("Loss name 'MeanSquare' is deprecated; please use 'Quadratic' instead.")
      parms$loss <- "Quadratic"
    } else 
      parms$loss <- loss
  }
  if (!missing(distribution))
    parms$distribution <- distribution
  if (!missing(quantile_alpha))
    parms$quantile_alpha <- quantile_alpha
  if (!missing(tweedie_power))
    parms$tweedie_power <- tweedie_power
  if (!missing(huber_alpha))
    parms$huber_alpha <- huber_alpha
  if (!missing(score_interval))
    parms$score_interval <- score_interval
  if (!missing(score_training_samples))
    parms$score_training_samples <- score_training_samples
  if (!missing(score_validation_samples))
    parms$score_validation_samples <- score_validation_samples
  if (!missing(score_duty_cycle))
    parms$score_duty_cycle <- score_duty_cycle
  if (!missing(classification_stop))
    parms$classification_stop <- classification_stop
  if (!missing(regression_stop))
    parms$regression_stop <- regression_stop
  if (!missing(stopping_rounds))
    parms$stopping_rounds <- stopping_rounds
  if (!missing(stopping_metric))
    parms$stopping_metric <- stopping_metric
  if (!missing(stopping_tolerance))
    parms$stopping_tolerance <- stopping_tolerance
  if (!missing(max_runtime_secs))
    parms$max_runtime_secs <- max_runtime_secs
  if (!missing(score_validation_sampling))
    parms$score_validation_sampling <- score_validation_sampling
  if (!missing(diagnostics))
    parms$diagnostics <- diagnostics
  if (!missing(fast_mode))
    parms$fast_mode <- fast_mode
  if (!missing(force_load_balance))
    parms$force_load_balance <- force_load_balance
  if (!missing(variable_importances))
    parms$variable_importances <- variable_importances
  if (!missing(replicate_training_data))
    parms$replicate_training_data <- replicate_training_data
  if (!missing(single_node_mode))
    parms$single_node_mode <- single_node_mode
  if (!missing(shuffle_training_data))
    parms$shuffle_training_data <- shuffle_training_data
  if (!missing(missing_values_handling))
    parms$missing_values_handling <- missing_values_handling
  if (!missing(quiet_mode))
    parms$quiet_mode <- quiet_mode
  if (!missing(autoencoder))
    parms$autoencoder <- autoencoder
  if (!missing(sparse))
    parms$sparse <- sparse
  if (!missing(col_major))
    parms$col_major <- col_major
  if (!missing(average_activation))
    parms$average_activation <- average_activation
  if (!missing(sparsity_beta))
    parms$sparsity_beta <- sparsity_beta
  if (!missing(max_categorical_features))
    parms$max_categorical_features <- max_categorical_features
  if (!missing(reproducible))
    parms$reproducible <- reproducible
  if (!missing(export_weights_and_biases))
    parms$export_weights_and_biases <- export_weights_and_biases
  if (!missing(mini_batch_size))
    parms$mini_batch_size <- mini_batch_size
  if (!missing(categorical_encoding))
    parms$categorical_encoding <- categorical_encoding
  if (!missing(elastic_averaging))
    parms$elastic_averaging <- elastic_averaging
  if (!missing(elastic_averaging_moving_rate))
    parms$elastic_averaging_moving_rate <- elastic_averaging_moving_rate
  if (!missing(elastic_averaging_regularization))
    parms$elastic_averaging_regularization <- elastic_averaging_regularization
  # Error check and build model
  .h2o.modelJob('deeplearning', parms, h2oRestApiVersion = 3, verbose=verbose) 
}

#' Anomaly Detection via H2O Deep Learning Model
#'
#' Detect anomalies in an H2O dataset using an H2O deep learning model with
#' auto-encoding.
#'
#' @param object An \linkS4class{H2OAutoEncoderModel} object that represents the
#'        model to be used for anomaly detection.
#' @param data An H2OFrame object.
#' @param per_feature Whether to return the per-feature squared reconstruction error
#' @return Returns an H2OFrame object containing the
#'         reconstruction MSE or the per-feature squared error.
#' @seealso \code{\link{h2o.deeplearning}} for making an H2OAutoEncoderModel.
#' @examples
#' \donttest{
#' library(h2o)
#' h2o.init()
#' prosPath = system.file("extdata", "prostate.csv", package = "h2o")
#' prostate.hex = h2o.importFile(path = prosPath)
#' prostate.dl = h2o.deeplearning(x = 3:9, training_frame = prostate.hex, autoencoder = TRUE,
#'                                hidden = c(10, 10), epochs = 5)
#' prostate.anon = h2o.anomaly(prostate.dl, prostate.hex)
#' head(prostate.anon)
#' prostate.anon.per.feature = h2o.anomaly(prostate.dl, prostate.hex, per_feature=TRUE)
#' head(prostate.anon.per.feature)
#' }
#' @export
h2o.anomaly <- function(object, data, per_feature=FALSE) {
url <- paste0('Predictions/models/', object@model_id, '/frames/',h2o.getId(data))
res <- .h2o.__remoteSend(url, method = "POST", reconstruction_error=TRUE, reconstruction_error_per_feature=per_feature)
key <- res$model_metrics[[1L]]$predictions$frame_id$name
h2o.getFrame(key)
}

