% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w2vutils.R
\name{h2o.toFrame}
\alias{h2o.toFrame}
\title{Convert a word2vec model into an H2OFrame}
\usage{
h2o.toFrame(word2vec)
}
\arguments{
\item{word2vec}{A word2vec model.}
}
\description{
Converts a given word2vec model into an H2OFrame. The frame represents learned word embeddings
}
\examples{
\dontrun{
h2o.init()

# Build a dummy word2vec model
data <- as.character(as.h2o(c("a", "b", "a")))
w2v_model <- h2o.word2vec(data, sent_sample_rate = 0, min_word_freq = 0, epochs = 1, vec_size = 2)

# Transform words to vectors and return average vector for each sentence
h2o.toFrame(w2v_model) # -> Frame made of 2 rows and 2 columns
}
}
