% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.upload_mojo}
\alias{h2o.upload_mojo}
\title{Imports a MOJO from a local filesystem, creating a Generic model with it.}
\usage{
h2o.upload_mojo(mojo_local_file_path)
}
\arguments{
\item{mojo_local_file_path}{Filesystem path to the model imported}
}
\value{
Returns H2O Generic Model embedding given MOJO model
}
\description{
Usage example:
mojo_model <- h2o.upload_mojo(model_file_path = "/path/to/local/mojo.zip")
predictions <- h2o.predict(mojo_model, dataset)
}
\examples{
\dontrun{

# Import default Iris dataset as H2O frame
data <- as.h2o(iris)

# Train a very simple GBM model
features <- c("Sepal.Length", "Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")
original_model <- h2o.gbm(x = features, y = "Species", training_frame = data)

# Download the trained GBM model as MOJO (temporary directory used in this example)
mojo_original_name <- h2o.download_mojo(model = original_model, path = tempdir())
mojo_original_path <- paste0(tempdir(), "/", mojo_original_name)

# Upload the MOJO from local filesystem and obtain a Generic model
mojo_model <- h2o.upload_mojo(mojo_original_path)

# Perform scoring with the generic model
predictions  <- h2o.predict(mojo_model, data)
}
}
