% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{predict_contributions.H2OModel}
\alias{predict_contributions.H2OModel}
\alias{h2o.predict_contributions}
\title{Predict feature contributions - SHAP values on an H2O Model (only DRF, GBM and XGBoost models).}
\usage{
predict_contributions.H2OModel(
  object,
  newdata,
  output_format = c("original", "compact"),
  ...
)

h2o.predict_contributions(
  object,
  newdata,
  output_format = c("original", "compact"),
  ...
)
}
\arguments{
\item{object}{a fitted \linkS4class{H2OModel} object for which prediction is
desired}

\item{newdata}{An H2OFrame object in which to look for
variables with which to predict.}

\item{output_format}{Specify how to output feature contributions in XGBoost - XGBoost by default outputs
contributions for 1-hot encoded features, specifying a compact output format will produce
a per-feature contribution. Defaults to original.}

\item{...}{additional arguments to pass on.}
}
\value{
Returns an H2OFrame contain feature contributions for each input row.
}
\description{
Returned H2OFrame has shape (#rows, #features + 1) - there is a feature contribution column for each input
feature, the last column is the model bias (same value for each row). The sum of the feature contributions
and the bias term is equal to the raw prediction of the model. Raw prediction of tree-based model is the sum
of the predictions of the individual trees before the inverse link function is applied to get the actual
prediction. For Gaussian distribution the sum of the contributions is equal to the model prediction.
}
\details{
Note: Multinomial classification models are currently not supported.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate_gbm <- h2o.gbm(3:9, "AGE", prostate)
h2o.predict(prostate_gbm, prostate)
h2o.predict_contributions(prostate_gbm, prostate)
}
}
\seealso{
\code{\link{h2o.gbm}} and  \code{\link{h2o.randomForest}} for model
         generation in h2o.
}
