% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.genericModel}
\alias{h2o.genericModel}
\title{Imports a model under given path, creating a Generic model with it.}
\usage{
h2o.genericModel(mojo_file_path, model_id = NULL)
}
\arguments{
\item{mojo_file_path}{Filesystem path to the model imported}

\item{model_id}{Model ID, default is NULL}
}
\value{
Returns H2O Generic Model based on given embedded model
}
\description{
Usage example:
generic_model <- h2o.genericModel(model_file_path = "/path/to/mojo.zip")
predictions <- h2o.predict(generic_model, dataset)
}
\examples{
\dontrun{

# Import default Iris dataset as H2O frame
data <- as.h2o(iris)

# Train a very simple GBM model
features <- c("Sepal.Length", "Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")
original_model <- h2o.gbm(x = features, y = "Species", training_frame = data)

# Download the trained GBM model as MOJO (temporary directory used in this example)
mojo_original_name <- h2o.download_mojo(model = original_model, path = tempdir())
mojo_original_path <- paste0(tempdir(), "/", mojo_original_name)

# Import the MOJO as Generic model
generic_model <- h2o.genericModel(mojo_original_path)

# Perform scoring with the generic model
generic_model_predictions  <- h2o.predict(generic_model, data)
}
}
