% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.get_regression_influence_diagnostics}
\alias{h2o.get_regression_influence_diagnostics}
\title{Extracts a list of H2OFrames containing regression influence diagnostics for predictor subsets of various sizes or
just one H2OFrame containing regression influence diagnostics for predictor subsets of one fixed size}
\usage{
h2o.get_regression_influence_diagnostics(model, predictorSize = -1)
}
\arguments{
\item{model}{an \linkS4class{H2OModel} object.}

\item{predictorSize}{predictor subset size.  If specified, will only return model coefficients of that subset size.  If
not specified will return a lists of model coefficient dicts for all predictor subset size.}
}
\description{
Extracts a list of H2OFrames containing regression influence diagnostics for predictor subsets of various sizes or
just one H2OFrame containing regression influence diagnostics for predictor subsets of one fixed size
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement", "power", "weight", "acceleration", "year")
response <- "acceleration"
cars_model <- h2o.modelSelection(y=response, 
                                 x=predictors, 
                                 training_frame = cars, 
                                 min_predictor_number=2, 
                                 mode="backward", 
                                 influence="dfbetas",
                                 lambda=0.0,
                                 family="gaussian")
rid_frame <- h2o.get_regression_influence_diagnostics(cars_model, predictorSize=3)
}
}
