% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.as_date}
\alias{h2o.as_date}
\title{Convert between character representations and objects of Date class}
\usage{
h2o.as_date(x, format, ...)
}
\arguments{
\item{x}{H2OFrame column of strings or factors to be converted}

\item{format}{A character string indicating date pattern}

\item{...}{Further arguments to be passed from or to other methods.}
}
\description{
Functions to convert between character representations and objects of class "Date" representing calendar dates.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/jira/v-11-eurodate.csv"
hdf <- h2o.importFile(f)
h2o.as_date(hdf["ds5"], "\%d.\%m.\%y \%H:\%M")
}
}
