% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.betweenss}
\alias{h2o.betweenss}
\title{Get the between cluster sum of squares}
\usage{
h2o.betweenss(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OClusteringModel} object.}

\item{train}{Retrieve the training between cluster sum of squares}

\item{valid}{Retrieve the validation between cluster sum of squares}

\item{xval}{Retrieve the cross-validation between cluster sum of squares}
}
\description{
Get the between cluster sum of squares.
If "train", "valid", and "xval" parameters are FALSE (default), then the training betweenss value is returned. If more
than one parameter is set to TRUE, then a named vector of betweenss' are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
fr <- h2o.importFile("https://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv")
predictors <- c("sepal_len", "sepal_wid", "petal_len", "petal_wid")
km <- h2o.kmeans(x = predictors, training_frame = fr, k = 3, nfolds = 3)
h2o.betweenss(km, train = TRUE)
}
}
