% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{h2o.shutdown}
\alias{h2o.shutdown}
\title{Shut Down H2O Instance}
\usage{
h2o.shutdown(prompt = TRUE)
}
\arguments{
\item{prompt}{A \code{logical} value indicating whether to prompt the user before shutting down the H2O server.}
}
\description{
Shut down the specified instance. All data will be lost.
}
\details{
This method checks if H2O is running at the specified IP address and port, and if it is, shuts down that H2O instance.
}
\note{
Users must call h2o.shutdown explicitly in order to shut down the local H2O instance started by R. If R is closed before H2O, then an attempt will be made to automatically shut down H2O. This only applies to local instances started with h2o.init, not remote H2O servers.
}
\section{WARNING}{
 All data, models, and other values stored on the server will be lost! Only call this function if you and all other clients connected to the H2O server are finished and have saved your work.
}

\examples{
# Don't run automatically to prevent accidentally shutting down a cluster
\dontrun{
library(h2o)
h2o.init()
h2o.shutdown()
}
}
\seealso{
\code{\link{h2o.init}}
}
