% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{H2OClusteringModel-class}
\alias{H2OClusteringModel-class}
\title{The H2OClusteringModel object.}
\description{
This virtual class represents a clustering model built by H2O.
}
\details{
This object has slots for the key, which is a character string that points to the model key existing in the H2O cloud,
the data used to build the model (an object of class Frame).
}
\section{Slots}{

\describe{
\item{\code{model_id}}{A \code{character} string specifying the key for the model fit in the H2O cloud's key-value store.}

\item{\code{algorithm}}{A \code{character} string specifying the algorithm that was used to fit the model.}

\item{\code{parameters}}{A \code{list} containing the parameter settings that were used to fit the model that differ from the defaults.}

\item{\code{allparameters}}{A \code{list} containing all parameters used to fit the model.}

\item{\code{model}}{A \code{list} containing the characteristics of the model returned by the algorithm.
\describe{
  \item{size }{The number of points in each cluster.}
  \item{totss }{Total sum of squared error to grand mean.}
  \item{withinss }{A vector of within-cluster sum of squared error.}
  \item{tot_withinss }{Total within-cluster sum of squared error.}
  \item{betweenss }{Between-cluster sum of squared error.}
}}
}}

