% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.kmeans}
\alias{h2o.kmeans}
\title{KMeans Model in H2O}
\usage{
h2o.kmeans(training_frame, x, k, model_id, max_iterations = 1000,
  standardize = TRUE, init = c("Furthest", "Random", "PlusPlus"), seed,
  nfolds = 0, fold_column = NULL, fold_assignment = c("AUTO", "Random",
  "Modulo"), keep_cross_validation_predictions = FALSE)
}
\arguments{
\item{training_frame}{An H2O Frame object containing the
variables in the model.}

\item{x}{(Optional) A vector containing the data columns on
which k-means operates.}

\item{k}{The number of clusters. Must be between 1 and
1e7 inclusive. k may be omitted if the user specifies the
initial centers in the init parameter. If k is not omitted,
in this case, then it should be equal to the number of
user-specified centers.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If
none is given, an id will automatically be generated.}

\item{max_iterations}{The maximum number of iterations allowed. Must be between 0}

\item{standardize}{Logical, indicates whether the data should be
standardized before running k-means.}

\item{init}{A character string that selects the initial set of k cluster
centers. Possible values are "Random": for random initialization,
"PlusPlus": for k-means plus initialization, or "Furthest": for
initialization at the furthest point from each successive center.
Additionally, the user may specify a the initial centers as a matrix,
data.frame, Frame, or list of vectors. For matrices,
data.frames, and Frames, each row of the respective structure
is an initial center. For lists of vectors, each vector is an
initial center.}

\item{seed}{(Optional) Random seed used to initialize the cluster centroids.}

\item{nfolds}{(Optional) Number of folds for cross-validation. If \code{nfolds >= 2}, then \code{validation} must remain empty.}

\item{fold_column}{(Optional) Column with cross-validation fold index assignment per observation}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified
Must be "AUTO", "Random" or "Modulo"}

\item{keep_cross_validation_predictions}{Whether to keep the predictions of the cross-validation models}
}
\value{
Returns an object of class \linkS4class{H2OClusteringModel}.
}
\description{
Performs k-means clustering on an H2O dataset.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
h2o.kmeans(training_frame = prostate.hex, k = 10, x = c("AGE", "RACE", "VOL", "GLEASON"))
}
}
\seealso{
\code{\link{h2o.cluster_sizes}}, \code{\link{h2o.totss}}, \code{\link{h2o.num_iterations}},
         \code{\link{h2o.betweenss}}, \code{\link{h2o.tot_withinss}}, \code{\link{h2o.withinss}},
         \code{\link{h2o.centersSTD}}, \code{\link{h2o.centers}}
}

