% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.var}
\alias{h2o.var}
\alias{var}
\title{Variance of a column.}
\usage{
h2o.var(x, y = NULL, na.rm = FALSE, use)

var(x, y = NULL, na.rm = FALSE, use)
}
\arguments{
\item{x}{An H2O Frame object.}

\item{y}{\code{NULL} (default) or a column of an H2O Frame object. The default is equivalent to y = x (but more efficient).}

\item{na.rm}{\code{logical}. Should missing values be removed?}

\item{use}{An optional character string to be used in the presence of missing values. This must be one of the following strings. "everything", "all.obs", or "complete.obs".}
}
\description{
Obtain the variance of a column of a parsed H2O data object.
}
\examples{
\donttest{
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
var(prostate.hex$AGE)
}
}
\seealso{
\code{\link[stats]{var}} for the base R implementation. \code{\link{h2o.sd}} for standard deviation.
}

