% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CommonFG.R
\docType{class}
\name{CommonFG}
\alias{CommonFG}
\alias{CommonFG-class}
\alias{[,CommonFG,character,character,ANY-method}
\alias{[,CommonFG,character,missing,missing-method}
\alias{[,CommonFG,missing,character,ANY-method}
\alias{[<-,CommonFG,character,character-method}
\alias{[<-,CommonFG,missing,character-method}
\alias{h5close}
\title{The CommonFG Class}
\usage{
h5close(.Object)

\S4method{[}{CommonFG,character,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CommonFG,character,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{CommonFG,character,character}(x, i, j, ...) <- value

\S4method{[}{CommonFG,missing,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CommonFG,missing,character}(x, i, j, ...) <- value
}
\arguments{
\item{.Object}{CommonFG; S4 object of class \code{CommonFG};}

\item{x}{CommonFG; object to be subsetted}

\item{i}{character; Name of \code{\link{H5Group}}}

\item{j}{character; Name of \code{\link{DataSet}}}

\item{...}{Additional arguments passed to \code{\link{createDataSet}}; only
relevant for assignment operator.}

\item{drop}{logical; specify if class of result set should be dropped (not
implemented yet).}

\item{value}{vector/matrix/array; Value to be assigend to dataset}
}
\description{
\code{CommonFG} is the base class of \code{\link{H5File}} and \code{\link{H5Group}}
and represents common  functionality of these two classes. The CommonFG base
class supports various subsetting operators to easily access and manipulate
\code{\link{H5Group}} and \code{\link{DataSet}} objects
(see also \code{\link{CommonFG-Group}} and \code{\link{CommonFG-DataSet}}).
}
\details{
Subsetting operators on \code{CommonFG} objects represent a convenient way
to create/access \code{\link{H5Group}} and \code{\link{DataSet}} objects.
Currently, only character arguments are supported whereas the first argument
specifies the group to be created/accesses and the second the dataset name.

Groups can be created/accessed by simply using one character parameter, e.g.
\code{group <- obj["groupname"]}.

DataSets can be either accessed by using
\code{dset <- obj["groupname", "datasetname"]} if existing or initialized by
using \code{obj["groupname", "datasetname"] <- value}.

All created objects e.g. \code{group} or \code{dset} should be closed in the
end using \code{h5close}.
}
\examples{
file <- H5File("test.h5")
# Create new DataSet 'testset' in H5Group 'testgroup'
file["testgroup", "testset"] <- matrix(1:9, nrow = 3)
# Create new DataSet 'testset2' in file root
file[, "testset2"] <- 1:10
# Retrieve H5Group 'testgroup'
group <- file["testgroup"]
# Retrieve H5Group 'testset'
dset <- group[,"testset"]
h5close(dset)
h5close(group)
h5close(file)
file.remove("test.h5")
}
\seealso{
\code{\link{CommonFG-Group}} \code{\link{CommonFG-DataSet}}
\code{\link{H5Location-Attribute}}
}

