% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choiceRT_lba_single.R
\name{choiceRT_lba_single}
\alias{choiceRT_lba_single}
\title{Choice Reaction Time task, linear ballistic accumulator modeling}
\usage{
choiceRT_lba_single(data = "choose", niter = 3000, nwarmup = 1000,
  nchain = 2, ncore = 2, nthin = 1, inits = "random",
  indPars = "mean", saveDir = NULL, email = NULL,
  modelRegressor = FALSE, adapt_delta = 0.95, stepsize = 1,
  max_treedepth = 10)
}
\arguments{
\item{data}{A .txt file containing the data to be modeled. Data columns should be labelled as follows: "subjID", "choice", "RT", and "condition". See \bold{Details} below for more information.}

\item{niter}{Number of iterations, including warm-up.}

\item{nwarmup}{Number of iterations used for warm-up only.}

\item{nchain}{Number of chains to be run.}

\item{ncore}{Integer value specifying how many CPUs to run the MCMC sampling on. Defaults to 1.}

\item{nthin}{Every \code{i == nthin} sample will be used to generate the posterior distribution. Defaults to 1. A higher number can be used when auto-correlation within the MCMC sampling is high.}

\item{inits}{Character value specifying how the initial values should be generated. Options are "fixed" or "random" or your own initial values.}

\item{indPars}{Character value specifying how to summarize individual parameters. Current options are: "mean", "median", or "mode".}

\item{saveDir}{Path to directory where .RData file of model output (\code{modelData}) can be saved. Leave blank if not interested.}

\item{email}{Character value containing email address to send notification of completion. Leave blank if not interested.}

\item{modelRegressor}{Exporting model-based regressors? TRUE or FALSE. Currently not available for this model.}

\item{adapt_delta}{Floating point number representing the target acceptance probability of a new sample in the MCMC chain. Must be between 0 and 1. See \bold{Details} below.}

\item{stepsize}{Integer value specifying the size of each leapfrog step that the MCMC sampler can take on each new iteration. See \bold{Details} below.}

\item{max_treedepth}{Integer value specifying how many leapfrog steps that the MCMC sampler can take on each new iteration. See \bold{Details} below.}
}
\value{
\code{modelData}  A class \code{'hBayesDM'} object with the following components:
\describe{
 \item{\code{model}}{Character string with the name of the model (\code{"choiceRT_lba_single"}).}
 \item{\code{allIndPars}}{\code{'data.frame'} containing the summarized parameter 
   values (as specified by \code{'indPars'}) for each subject.}
 \item{\code{parVals}}{A \code{'list'} where each element contains posterior samples
   over different model parameters. }
 \item{\code{fit}}{A class \code{'stanfit'} object containing the fitted model.}
 \item{\code{rawdata}}{\code{"data.frame"} containing the raw data used to fit the model, as specified by the user.}
}
}
\description{
Individual Bayesian Modeling of choice/reaction time data with the following parameters: "d" (boundary), "A" (upper boundary of starting point), "v" (drift rate), "tau" (non-decision time).
The model published in Annis, J., Miller, B. J., & Palmeri, T. J. (2016). Bayesian inference with Stan: A tutorial on adding custom distributions. Behavior research methods, 1-24.

\strong{MODEL:}
Brown and Heathcote LBA model - single subject. Note that this implementation estimates a different drift rate
for each condition-choice pair. For example, if the task involves deciding between two stimuli on each trial, and
there are two different conditions throughout the task (e.g. speed versus accuracy), a total of 4 (2 stimuli by 2 conditions)
drift rates will be estimated. For details on implementation, see Annis et al. (2016).
}
\details{
This section describes some of the function arguments in greater detail.

\strong{data} should be assigned a character value specifying the full path and name of the file, including the file extension 
(e.g. ".txt"), that contains the behavioral data of all subjects of interest for the current analysis. 
The file should be a \strong{tab-delimited} text (.txt) file whose rows represent trial-by-trial observations and columns 
represent variables. For choice/reaction time tasks, there should be four columns of data 
with the labels "choice", "RT", and "condition". It is not necessary for the columns to be in this particular order, 
however it is necessary that they be labelled correctly and contain the information below:
\describe{
 \item{\code{"subjID"}}{A unique identifier for each subject within data-set to be analyzed.}
 \item{\code{"choice"}}{An integer representing the choice made on the current trial. (e.g., 1 1 3 2 1 2).}
 \item{\code{"RT"}}{A floating number the choice reaction time in \strong{seconds}. (e.g., 0.435 0.383 0.314 0.309, etc.).}
 \item{\code{"condition"}}{An integer representing the condition of the current trail (e.g., 1 2 3 4).}
}
\strong{*}Note: The data.txt file may contain other columns of data (e.g. "Reaction_Time", "trial_number", etc.), but only the data with the column
names listed above will be used for analysis/modeling. As long as the columns above are present and labelled correctly,
there is no need to remove other miscellaneous data columns.
 
\strong{nwarmup} is a numerical value that specifies how many MCMC samples should not be stored upon the 
beginning of each chain. For those familiar with Bayesian methods, this value is equivalent to a burn-in sample. 
Due to the nature of MCMC sampling, initial values (where the sampling chain begins) can have a heavy influence 
on the generated posterior distributions. The \strong{nwarmup} argument can be set to a high number in order to curb the 
effects that initial values have on the resulting posteriors.  

\strong{nchain} is a numerical value that specifies how many chains (i.e. independent sampling sequences) should be
used to draw samples from the posterior distribution. Since the posteriors are generated from a sampling 
process, it is good practice to run multiple chains to ensure that a representative posterior is attained. When
sampling is completed, the multiple chains may be checked for convergence with the \code{plot(myModel, type = "trace")}
command. The chains should resemble a "furry caterpillar".

\strong{nthin} is a numerical value that specifies the "skipping" behavior of the MCMC samples being chosen 
to generate the posterior distributions. By default, \strong{nthin} is equal to 1, hence every sample is used to 
generate the posterior. 

\strong{Contol Parameters:} adapt_delta, stepsize, and max_treedepth are advanced options that give the user more control 
over Stan's MCMC sampler. The Stan creators recommend that only advanced users change the default values, as alterations
can profoundly change the sampler's behavior. Refer to Hoffman & Gelman (2014, Journal of Machine Learning Research) for 
more information on the functioning of the sampler control parameters. One can also refer to section 58.2 of the  
\href{http://mc-stan.org/documentation/}{Stan User's Manual} for a less technical description of these arguments.
}
\examples{
\dontrun{
# Run the model and store results in "output"
output <- choiceRT_lba_single(data = "example", niter = 2000, nwarmup = 1000, nchain = 3, ncore = 3)

# Visually check convergence of the sampling chains (should like like 'hairy caterpillars')
plot(output, type = 'trace')

# Check Rhat values (all Rhat values should be less than or equal to 1.1)
rhat(output)

# Plot the posterior distributions of the hyper-parameters (distributions should be unimodal)
plot(output)

# Show the WAIC and LOOIC model fit estimates 
printFit(output)
}
}
\references{
Brown, S. D., & Heathcote, A. (2008). The simplest complete model of choice response time: Linear ballistic accumulation. 
Cognitive Psychology, 57(3), 153-178. http://doi.org/10.1016/j.cogpsych.2007.12.002

Annis, J., Miller, B. J., & Palmeri, T. J. (2016). Bayesian inference with Stan: A tutorial on adding custom distributions. 
Behavior research methods, 1-24.

Hoffman, M. D., & Gelman, A. (2014). The No-U-turn sampler: adaptively setting path lengths in Hamiltonian Monte Carlo. The 
Journal of Machine Learning Research, 15(1), 1593-1623.
}
\seealso{
We refer users to our in-depth tutorial for an example of using hBayesDM: \url{https://rpubs.com/CCSL/hBayesDM}
}
