/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_ra_noRA_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ra_noRA");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_ra_noRA");
    reader.add_event(109, 94, "end", "model_ra_noRA");
    return reader;
}

#include <meta_header.hpp>
 class model_ra_noRA : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > gain;
    vector<vector<double> > loss;
    vector<vector<double> > cert;
    vector<vector<int> > gamble;
public:
    model_ra_noRA(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_ra_noRA(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_ra_noRA_namespace::model_ra_noRA";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("gain", "N", N);
            validate_non_negative_index("gain", "T", T);
            context__.validate_dims("data initialization", "gain", "double", context__.to_vec(N,T));
            validate_non_negative_index("gain", "N", N);
            validate_non_negative_index("gain", "T", T);
            gain = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("gain");
            pos__ = 0;
            size_t gain_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < gain_limit_1__; ++i_1__) {
                size_t gain_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < gain_limit_0__; ++i_0__) {
                    gain[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("loss", "N", N);
            validate_non_negative_index("loss", "T", T);
            context__.validate_dims("data initialization", "loss", "double", context__.to_vec(N,T));
            validate_non_negative_index("loss", "N", N);
            validate_non_negative_index("loss", "T", T);
            loss = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("loss");
            pos__ = 0;
            size_t loss_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < loss_limit_1__; ++i_1__) {
                size_t loss_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < loss_limit_0__; ++i_0__) {
                    loss[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("cert", "N", N);
            validate_non_negative_index("cert", "T", T);
            context__.validate_dims("data initialization", "cert", "double", context__.to_vec(N,T));
            validate_non_negative_index("cert", "N", N);
            validate_non_negative_index("cert", "T", T);
            cert = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("cert");
            pos__ = 0;
            size_t cert_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < cert_limit_1__; ++i_1__) {
                size_t cert_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < cert_limit_0__; ++i_0__) {
                    cert[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("gamble", "N", N);
            validate_non_negative_index("gamble", "T", T);
            context__.validate_dims("data initialization", "gamble", "int", context__.to_vec(N,T));
            validate_non_negative_index("gamble", "N", N);
            validate_non_negative_index("gamble", "T", T);
            gamble = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("gamble");
            pos__ = 0;
            size_t gamble_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < gamble_limit_1__; ++i_1__) {
                size_t gamble_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < gamble_limit_0__; ++i_0__) {
                    gamble[i_0__][i_1__] = vals_i__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"gain[k0__][k1__]",gain[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"loss[k0__][k1__]",loss[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 22;
            current_statement_begin__ = 23;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],-(1));
                    check_less_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],1);
                }
            }
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 30;
            validate_non_negative_index("mu_pr", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 31;
            validate_non_negative_index("sigma", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 32;
            validate_non_negative_index("lambda_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 33;
            validate_non_negative_index("tau_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_ra_noRA() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "2", 2);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(2));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "2", 2);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("lambda_pr")))
            throw std::runtime_error("variable lambda_pr missing");
        vals_r__ = context__.vals_r("lambda_pr");
        pos__ = 0U;
        validate_non_negative_index("lambda_pr", "N", N);
        context__.validate_dims("initialization", "lambda_pr", "vector_d", context__.to_vec(N));
        vector_d lambda_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        validate_non_negative_index("tau_pr", "N", N);
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(2,lp__);
            else
                mu_pr = in__.vector_constrain(2);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,2,lp__);
            else
                sigma = in__.vector_lb_constrain(0,2);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  lambda_pr;
            (void) lambda_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_pr = in__.vector_constrain(N,lp__);
            else
                lambda_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau_pr;
            (void) tau_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_pr = in__.vector_constrain(N,lp__);
            else
                tau_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 37;
            validate_non_negative_index("lambda", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
            (void) lambda;  // dummy to suppress unused var warning

            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 40;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 41;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 5), 
                            "assigning variable lambda");
                current_statement_begin__ = 42;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 5), 
                            "assigning variable tau");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(lambda(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(tau(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 37;
            check_greater_or_equal(function__,"lambda",lambda,0);
            check_less_or_equal(function__,"lambda",lambda,5);
            current_statement_begin__ = 38;
            check_greater_or_equal(function__,"tau",tau,0);
            check_less_or_equal(function__,"tau",tau,5);

            // model body

            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1.0));
            current_statement_begin__ = 50;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 53;
            lp_accum__.add(normal_log<propto__>(lambda_pr, 0, 1.0));
            current_statement_begin__ = 54;
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1.0));
            current_statement_begin__ = 56;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 57;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                    current_statement_begin__ = 58;
                    local_scalar_t__ evSafe;
                    (void) evSafe;  // dummy to suppress unused var warning

                    stan::math::initialize(evSafe, DUMMY_VAR__);
                    stan::math::fill(evSafe,DUMMY_VAR__);
                    current_statement_begin__ = 59;
                    local_scalar_t__ evGamble;
                    (void) evGamble;  // dummy to suppress unused var warning

                    stan::math::initialize(evGamble, DUMMY_VAR__);
                    stan::math::fill(evGamble,DUMMY_VAR__);
                    current_statement_begin__ = 60;
                    local_scalar_t__ pGamble;
                    (void) pGamble;  // dummy to suppress unused var warning

                    stan::math::initialize(pGamble, DUMMY_VAR__);
                    stan::math::fill(pGamble,DUMMY_VAR__);


                    current_statement_begin__ = 63;
                    stan::math::assign(evSafe, get_base1(get_base1(cert,i,"cert",1),t,"cert",2));
                    current_statement_begin__ = 64;
                    stan::math::assign(evGamble, (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - (get_base1(lambda,i,"lambda",1) * get_base1(get_base1(loss,i,"loss",1),t,"loss",2)))));
                    current_statement_begin__ = 65;
                    stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                    current_statement_begin__ = 66;
                    lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2), pGamble));
                    }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("lambda_pr");
        names__.push_back("tau_pr");
        names__.push_back("lambda");
        names__.push_back("tau");
        names__.push_back("mu_lambda");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_ra_noRA_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d lambda_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 37;
            validate_non_negative_index("lambda", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
            (void) lambda;  // dummy to suppress unused var warning

            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 40;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 41;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 5), 
                            "assigning variable lambda");
                current_statement_begin__ = 42;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 5), 
                            "assigning variable tau");
            }

            // validate transformed parameters
            current_statement_begin__ = 37;
            check_greater_or_equal(function__,"lambda",lambda,0);
            check_less_or_equal(function__,"lambda",lambda,5);
            current_statement_begin__ = 38;
            check_greater_or_equal(function__,"tau",tau,0);
            check_less_or_equal(function__,"tau",tau,5);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 71;
            local_scalar_t__ mu_lambda;
            (void) mu_lambda;  // dummy to suppress unused var warning

            stan::math::initialize(mu_lambda, DUMMY_VAR__);
            stan::math::fill(mu_lambda,DUMMY_VAR__);
            current_statement_begin__ = 72;
            local_scalar_t__ mu_tau;
            (void) mu_tau;  // dummy to suppress unused var warning

            stan::math::initialize(mu_tau, DUMMY_VAR__);
            stan::math::fill(mu_tau,DUMMY_VAR__);
            current_statement_begin__ = 74;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 77;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 80;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 81;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 82;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 86;
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_pr,1,"mu_pr",1)) * 5));
            current_statement_begin__ = 87;
            stan::math::assign(mu_tau, (Phi_approx(get_base1(mu_pr,2,"mu_pr",1)) * 5));

            current_statement_begin__ = 90;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 91;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 92;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                    current_statement_begin__ = 93;
                    local_scalar_t__ evSafe;
                    (void) evSafe;  // dummy to suppress unused var warning

                    stan::math::initialize(evSafe, DUMMY_VAR__);
                    stan::math::fill(evSafe,DUMMY_VAR__);
                    current_statement_begin__ = 94;
                    local_scalar_t__ evGamble;
                    (void) evGamble;  // dummy to suppress unused var warning

                    stan::math::initialize(evGamble, DUMMY_VAR__);
                    stan::math::fill(evGamble,DUMMY_VAR__);
                    current_statement_begin__ = 95;
                    local_scalar_t__ pGamble;
                    (void) pGamble;  // dummy to suppress unused var warning

                    stan::math::initialize(pGamble, DUMMY_VAR__);
                    stan::math::fill(pGamble,DUMMY_VAR__);


                    current_statement_begin__ = 97;
                    stan::math::assign(evSafe, get_base1(get_base1(cert,i,"cert",1),t,"cert",2));
                    current_statement_begin__ = 98;
                    stan::math::assign(evGamble, (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - (get_base1(lambda,i,"lambda",1) * get_base1(get_base1(loss,i,"loss",1),t,"loss",2)))));
                    current_statement_begin__ = 99;
                    stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                    current_statement_begin__ = 100;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + bernoulli_log(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2),pGamble)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 103;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                bernoulli_rng(pGamble, base_rng__), 
                                "assigning variable y_pred");
                    }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 71;
            check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
            check_less_or_equal(function__,"mu_lambda",mu_lambda,5);
            current_statement_begin__ = 72;
            check_greater_or_equal(function__,"mu_tau",mu_tau,0);
            check_less_or_equal(function__,"mu_tau",mu_tau,5);
            current_statement_begin__ = 74;
            current_statement_begin__ = 77;

            // write generated quantities
        vars__.push_back(mu_lambda);
        vars__.push_back(mu_tau);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ra_noRA";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_ra_noRA_namespace::model_ra_noRA stan_model;


#endif
