% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/habCluster-package.R
\docType{package}
\name{habCluster-package}
\alias{habCluster}
\alias{habCluster-package}
\title{habCluster: Detecting Spatial Clustering Based on Connection Cost Between Grids}
\description{
Based on landscape connectivity, spatial boundaries were identified using community detection algorithm at grid level. Methods using raster as input and the value of each cell of the raster is the "smoothness" to indicate how easy the cell connecting with neighbor cells. Details about the 'habCluster' package methods can be found in Zhang et al. <bioRxiv:2022.05.06.490926>.

Spatial explicitly identify the structure of landscape base on cost (weighted) connection at grid scale, using community detection algorithm from graph theory.
}
\details{
Based on landscape connectivity, spatial boundaries were identified using community detection algorithm at grid level. Methods using raster as input and the value of each cell of the raster is the ‘smoothness’ to indicate how easy the cell connecting with neighbor cells. The method can be use to find habitat clusters for wildlife from a map of habitat suitability index, and thus can be used to detect the spatial boundaries among populations or other intraspecific units.


Key content of the 'habCluster' package include:\cr

\bold{Spatial Cluster Detection}

\code{\link{cluster}} Clustering cells from a raster by Community Detection Algorithm according to the connections between them and return a cluster map.
}
\section{Dependencies}{
 The 'habCluster' package relies heavily upon \code{\link{raster}}, \code{\link{Rcpp}}, and \code{\link{igraph}}.
}

\author{
Qiang Dai\cr \emph{Chengdu Institute of Biology, Chinese Academy of Sciences.}\cr

Maintainer: Qiang Dai \email{daiqiang@cib.ac.cn}
}
\keyword{internal}
\keyword{package}
