% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_new_stories}
\alias{get_new_stories}
\title{Hacker News newest stories}
\usage{
get_new_stories(max_items = NULL)
}
\arguments{
\item{max_items}{Maximum number of items to retrieve.
If max_items = NULL, returns all available}
}
\value{
list of new stories
}
\description{
Retrieves newest stories using Hacker News API
}
\details{
Parallel api requests can be enabled by running
\code{future::plan(future::multiprocess)}
}
\examples{
# get the newest story on Hacker News
newest_story <- get_new_stories(max_items = 1)
newest_story

\donttest{
# get all new stories on Hacker News
new_stories <- get_new_stories()
new_stories
}

}
