% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{cf_boot}
\alias{cf_boot}
\title{Bootstrapped CF mixin constructor}
\usage{
cf_boot(.cf = cf(), boot.R, boot.l, seed, sim, endcorr, cf.tsboot,
  icf.tsboot = NULL, resampling_method)
}
\arguments{
\item{.cf}{\code{cf} object to extend.}

\item{boot.R}{Integer, number of bootstrap samples used.}

\item{boot.l}{Integer, block length in the time-series bootstrap process.}

\item{seed}{Integer, random number generator seed used in bootstrap.}

\item{sim}{Character, \code{sim} argument of \link[boot]{tsboot}.}

\item{endcorr}{Boolean, \code{endcorr} argumetn of \link[boot]{tsboot}.}

\item{cf.tsboot}{List, result from the \link[boot]{tsboot} function for the real part.}

\item{icf.tsboot}{List, result from the \link[boot]{tsboot} function for the imaginay part.}

\item{resampling_method}{Character, either 'bootstrap' or 'jackknife'}
}
\value{
returns the input object of class \code{cf} with the bootstrap mixin added
}
\description{
Bootstrapped CF mixin constructor
}
\details{
The following fields will also be made available:
\itemize{
\item \code{cf0}: Numeric vector, mean value of original measurements, convenience copy of \code{cf.tsboot$t0}.
\item \code{tsboot.se}: Numeric vector, standard deviation over bootstrap samples.
\item \code{boot.samples}: Logical, indicating whether there are bootstrap samples available. This is deprecated and instead the presence of bootstrap samples should be queried with \code{inherits(cf, 'cf_boot')}.
\item \code{error_fn}: Function, takes a vector of samples and computes the error. In the bootstrap case this is just the \code{sd} function. Use this function instead of a \code{sd} in order to make the code compatible with jackknife samples.
}
}
\seealso{
Other cf constructors: 
\code{\link{cf_meta}()},
\code{\link{cf_orig}()},
\code{\link{cf_principal_correlator}()},
\code{\link{cf_shifted}()},
\code{\link{cf_smeared}()},
\code{\link{cf_subtracted}()},
\code{\link{cf_weighted}()},
\code{\link{cf}()}
}
\concept{cf constructors}
