% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.nlsfit.R
\name{plot.bootstrapfit}
\alias{plot.bootstrapfit}
\title{Plot a bootstrap NLS fit}
\usage{
\method{plot}{bootstrapfit}(x, ..., col.line = "black", col.band = "gray",
  opacity.band = 0.65, lty = c(1), lwd = c(1), supports = 1000,
  plot.range, error = x$error.function, ribbon.on.top = TRUE)
}
\arguments{
\item{x}{object returned by \code{bootstrap.nlsfit}}

\item{...}{Additional parameters passed to the \code{plotwitherror} function.}

\item{col.line}{line colour.}

\item{col.band}{error band colour.}

\item{opacity.band}{error band opacity.}

\item{lty}{line type of fitted curve.}

\item{lwd}{line width for fitted curve.}

\item{supports}{number of supporting points for plotting the function.}

\item{plot.range}{vector with two elements \code{c(min,max)} defining the
range in which fitline and errorband are plotted. Default is the range of
the data.}

\item{error}{Function to compute the standard error in resampling schemes.
Default is \link{sd} for bootstrap. For other resampling schemes this might
need to be changed.}

\item{ribbon.on.top}{Logical, controls whether the ribbon should be in
front of the data points. This is recommended when there are very many data
points and a highly constrained model.}
}
\value{
No return value.
}
\description{
Plot a bootstrap NLS fit
}
\seealso{
Other NLS fit functions: 
\code{\link{bootstrap.nlsfit}()},
\code{\link{parametric.bootstrap.cov}()},
\code{\link{parametric.bootstrap}()},
\code{\link{parametric.nlsfit.cov}()},
\code{\link{parametric.nlsfit}()},
\code{\link{predict.bootstrapfit}()},
\code{\link{print.bootstrapfit}()},
\code{\link{simple.nlsfit}()},
\code{\link{summary.bootstrapfit}()}
}
\concept{NLS fit functions}
