% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.nlsfit.R
\name{parametric.nlsfit}
\alias{parametric.nlsfit}
\title{NLS fit with parametric bootstrap}
\usage{
parametric.nlsfit(fn, par.guess, boot.R, y, dy, x, dx, lower = rep(x = -Inf,
  times = length(par.guess)), upper = rep(x = +Inf, times =
  length(par.guess)), ..., bootstrap = TRUE)
}
\arguments{
\item{fn}{\code{fn(par, x, ...)}. The (non-linear) function to be fitted to the
data. Its first argument must be the fit parameters named \code{par}. The
second must be \code{x}, the explaining variable. Additional parameters
might be passed to the function. Currently we pass \code{boot.r} which is \code{0}
for the original data and the ID (1, ...) of the bootstrap sample otherwise.
As more parameters might be added in the future it is recommended that the
fit function accepts \code{...} as the last parameter to be forward compatible.}

\item{par.guess}{initial guess values for the fit parameters.}

\item{boot.R}{numeric. Number of bootstrap samples to generate.}

\item{y}{the data as a one-dimensional numerical vector to be described by
the fit function.}

\item{dy, dx}{Numeric vector. Errors of the dependent and independent
variable, respectively. These do not need to be specified as they can be
computed from the bootstrap samples. In the case of parametric bootstrap it
might would lead to a loss of information if they were computed from the
pseudo-bootstrap samples. They must not be specified if a covariance matrix
is given.}

\item{x}{values of the explaining variable in form of a one-dimensional
numerical vector.}

\item{lower}{Numeric vector of length \code{length(par.guess)}
of lower bounds on the fit parameters. If missing, \code{-Inf}
will be set for all.}

\item{upper}{Numeric vector of length \code{length(par.guess)}
of upper bounds on the fit parameters. If missing, \code{+Inf}
will be set for all.}

\item{...}{Additional parameters passed to \code{fn}, \code{gr} and \code{dfn}.}

\item{bootstrap}{Shall the error calculation be performed using boostrap?
If not, the errors are estimated with help of the jacobian (either provided
in \code{gr} or calculated using the \code{numDeriv}-package).}
}
\value{
See \link{simple.nlsfit}.
}
\description{
NLS fit with parametric bootstrap
}
\examples{
## Declare some data.
value <- c(0.1, 0.2, 0.3)
dvalue <- c(0.01, 0.01, 0.015)
x <- c(1, 2, 3)
dx <- c(0.1, 0.1, 0.1)
boot.R <- 1500

fn <- function (par, x, ...) par[1] + par[2] * x

fit.result <- parametric.nlsfit(fn, c(1, 1), boot.R, value, dvalue, x, dx)
summary(fit.result)
}
\seealso{
Other NLS fit functions: 
\code{\link{bootstrap.nlsfit}()},
\code{\link{parametric.bootstrap.cov}()},
\code{\link{parametric.bootstrap}()},
\code{\link{parametric.nlsfit.cov}()},
\code{\link{plot.bootstrapfit}()},
\code{\link{predict.bootstrapfit}()},
\code{\link{print.bootstrapfit}()},
\code{\link{simple.nlsfit}()},
\code{\link{summary.bootstrapfit}()}
}
\concept{NLS fit functions}
