% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_oral_questions.R
\name{commons_oral_questions}
\alias{commons_oral_questions}
\alias{hansard_commons_oral_questions}
\title{Imports data on House of Commons oral questions}
\usage{
commons_oral_questions(mp_id = NULL, answering_department = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_commons_oral_questions(mp_id = NULL, answering_department = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{mp_id}{The ID of a given MP asking an oral question. Defaults to NULL.}

\item{answering_department}{The department that answers a question}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on all oral questions in the House of Commons.
}
\description{
Imports data on House of Commons oral questions
}
\examples{
\dontrun{

x <- commons_oral_questions(mp_id=4019, answering_department = 'education')

}
}
\seealso{
\code{\link{all_answered_questions}}

\code{\link{commons_answered_questions}}

\code{\link{commons_oral_question_times}}

\code{\link{commons_written_questions}}

\code{\link{lords_written_questions}}

\code{\link{mp_questions}}
}
\keyword{questions}
