% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lord_vote_record.R
\name{lord_vote_record}
\alias{lord_vote_record}
\alias{hansard_lord_vote_record}
\title{Accepts an ID number for a member of the House of Commons, and returns a tibble of their votes.}
\usage{
lord_vote_record(peer_id = NULL, lobby = "all", start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

hansard_lord_vote_record(peer_id = NULL, lobby = "all",
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{peer_id}{The ID number of a member of the House of Lords. A value must be included for this parameter. Use the \code{\link{lords_members}} to find IDs for members of the House of Lords. Defaults to NULL.}

\item{lobby}{Accepts one of 'all', 'content', 'notcontent'. 'content' returns votes where the peer voted 'content', 'notcontent' returns votes where the peer voted 'not content' and 'all' returns all available votes by the peer. Defaults to 'all'.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on the voting record of a member of the House of Lords
}
\description{
Accepts an ID number for a member of the House of Commons, and returns a tibble of their votes.
}
\examples{
\dontrun{
x <- lord_vote_record(530, lobby='all')

x <- lord_vote_record(530, lobby='content')

x <- lord_vote_record(530, lobby='notcontent')
}
}
\keyword{divisions}
