% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_amendments.R
\name{lords_amendments}
\alias{lords_amendments}
\alias{hansard_lords_amendments}
\title{House of Lords Amendments.}
\usage{
lords_amendments(decision = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = TRUE)

hansard_lords_amendments(decision = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{decision}{The decision on the amendments. Accepts one of
\code{'Withdrawn'}, \code{'Agreed'}, \code{'Disagreed'}, \code{'Pending'},
\code{'NotMoved'}, \code{'Disposed'}. This parameter is not case sensitive.
Defaults to \code{NULL}.}

\item{start_date}{Only includes amendments to bills introduced on or after
this date. Accepts character values in \code{'YYYY-MM-DD'} format, and
objects of class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt}
or anything else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes amendments to bills introduced on or before
this date. Accepts character values in \code{'YYYY-MM-DD'} format, and
objects of class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt}
or anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on amendments proposed by the House of Lords.
}
\description{
Returns a tibble with all available House of Lords amendments, subject
to parameters.
}
\examples{
\dontrun{
x <- lords_amendments()

x <- lords_amendments(decision = "Withdrawn")
}

}
