% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_answered_questions.R
\name{commons_answered_questions}
\alias{commons_answered_questions}
\alias{hansard_commons_answered_questions}
\title{House of Commons answered questions}
\usage{
commons_answered_questions(answering_department = NULL,
  answered_by = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake", verbose = TRUE)

hansard_commons_answered_questions(answering_department = NULL,
  answered_by = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake", verbose = TRUE)
}
\arguments{
\item{answering_department}{Accepts the name of a department or a
list of department names.  Returns a tibble with all answered questions
in the House of Commons from the given department. Defaults to \code{NULL}.}

\item{answered_by}{Accepts the ID of an MP, or a list of IDs. Returns a
tibble with all answered questions in the House of Commons by the given
MP(s). Defaults to \code{NULL}.}

\item{start_date}{Only includes questions answered introduced on or after
this date. Accepts character values in \code{'YYYY-MM-DD'} format, and
objects of class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt}
or anything else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes questions answered on or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts any style accepted by \link[snakecase]{to_any_case}.
Defaults to \code{'snake'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on all answered questions in the
House of Commons.
}
\description{
Imports data on House of Commons answered questions. If all
parameters are left empty, imports all available answered questions in a
tibble.

If \code{answering_department} and/or \code{answered_by} are
given a vector with multiple deparments/IDs, all possible combination of
those criteria are returned.
}
\examples{
\dontrun{
x <- commons_answered_questions(
  answering_department = c("health", "education"),
  answered_by = c("4019", "1542", "111"),
  start_date = "2017-01-01"
)

y <- commons_answered_questions(
  start_date = "2017-03-26",
  end_date = "2017-04-01"
)
}

}
\seealso{
\code{\link[=all_answered_questions]{all_answered_questions()}}

\code{\link[=commons_oral_questions]{commons_oral_questions()}}

\code{\link[=commons_oral_question_times]{commons_oral_question_times()}}

\code{\link[=commons_written_questions]{commons_written_questions()}}

\code{\link[=lords_written_questions]{lords_written_questions()}}

\code{\link[=mp_questions]{mp_questions()}}
}
