% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/members_search.R
\name{members_search}
\alias{members_search}
\alias{hansard_members_search}
\title{Search for an MP or Peer by name and constituency}
\usage{
members_search(search = NULL, tidy = TRUE, tidy_style = "snake",
  verbose = TRUE)

hansard_members_search(search = NULL, tidy = TRUE,
  tidy_style = "snake", verbose = TRUE)
}
\arguments{
\item{search}{Accepts any lucene query string, using * as a multiple
character wildcard, and ? as the single character wildcard. Searchs are
not case sensitive. If \code{NULL}, returns a tibble with all members of
both houses of parliament. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts any style accepted by \link[snakecase]{to_any_case}.
Defaults to \code{'snake'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with the results of the search.
}
\description{
Note that there are problems with the remote endpoint for this
API, and that correct search queries may not return any results.
}
\details{
Function searches for the string and returns a tibble with all matches from
both houses of parliament. Returns all partial matches in the members'
names, constituencies, twitter handle and webpage. The default search is
\code{NULL}, which returns a tibble of all members of both houses, the
same result as \code{members()}.
}
\examples{
\dontrun{
x <- members_search("*chris*")

x <- members_search(search = "*chris*")
}

}
\seealso{
\code{\link[=members]{members()}}
}
