## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(happign)
library(DT)
library(magrittr)

## ----echo=FALSE---------------------------------------------------------------
bad_request_wfs = data.frame(
   apikey = c("adresse", "adresse", "environnement", "environnement", "parcellaire", 
"transports", "transports", "transports"),
   layer_name = c("ADRESSE-PREMIUM.LIEN.HEXA:lien_adresse_hexa","ADRESSE-PREMIUM.LIEN.IRIS:lien_adresse_iris", "MESURES_COMPENSATOIRES:emprises_lineaires", "MESURES_COMPENSATOIRES:emprises_ponctuelles", "CADASTRALPARCELS.PARCELLAIRE_EXPRESS:borne_parcelle", "SECUROUT.TE:n_te_prescription", "SECUROUT.TE:n_te_rel_franpres", "SECUROUT.TE:n_te_rel_tronpres"
))


DT::datatable(bad_request_wfs)

## ----echo=FALSE---------------------------------------------------------------
rgdal_pb_wms = data.frame(
   apikey = c(rep("economie",21),
              "lambert93",
              rep("orthohisto",40),
              rep("satellite",22),
              rep("transport", 11)),
   layer_name = c(
      "DREAL.ZONAGE_PINEL",
      "INSEE.FILOSOFI.LOGEMENTS.SURFACE.MOYENNE.SECRET",
      "INSEE.FILOSOFI.NIVEAU.DE.VIE.SECRET",
      "INSEE.FILOSOFI.PART.ENFANTS.0.17.ANS.SECRET",
      "INSEE.FILOSOFI.PART.FAMILLES.MONOPARENTALES.SECRET",
      "INSEE.FILOSOFI.PART.INDIVIDUS.25.39.ANS.SECRET",
      "INSEE.FILOSOFI.PART.INDIVIDUS.40.54.ANS.SECRET",
      "INSEE.FILOSOFI.PART.INDIVIDUS.55.64.ANS.SECRET",
      "INSEE.FILOSOFI.PART.LOGEMENTS.APRES.1990.SECRET",
      "INSEE.FILOSOFI.PART.LOGEMENTS.AVANT.1945.SECRET",
      "INSEE.FILOSOFI.PART.LOGEMENTS.COLLECTIFS.SECRET",
      "INSEE.FILOSOFI.PART.LOGEMENTS.CONSTRUITS.1945.1970.SECRET",
      "INSEE.FILOSOFI.PART.LOGEMENTS.CONSTRUITS.1970.1990.SECRET",
      "INSEE.FILOSOFI.PART.LOGEMENTS.SOCIAUX.SECRET",
      "INSEE.FILOSOFI.PART.MENAGES.1.PERSONNE.SECRET",
      "INSEE.FILOSOFI.PART.MENAGES.5.PERSONNES.OUPLUS.SECRET",
      "INSEE.FILOSOFI.PART.MENAGES.MAISON.SECRET",
      "INSEE.FILOSOFI.PART.MENAGES.PAUVRES.SECRET",
      "INSEE.FILOSOFI.PART.MENAGES.PROPRIETAIRES.SECRET",
      "INSEE.FILOSOFI.PART.PLUS.65.ANS.SECRET",
      "INSEE.FILOSOFI.POPULATION",
      "SCANEM40_PYR_PNG_FXX_LAMB93",
      "ORTHOIMAGERY.ORTHOPHOTOS.1950-1965",
      "ORTHOIMAGERY.ORTHOPHOTOS.1980-1995",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC-EXPRESS.2018",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC-EXPRESS.2019",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC-EXPRESS.2020",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC.2012",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC.2013",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC.2014",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC.2015",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC.2016",
      "ORTHOIMAGERY.ORTHOPHOTOS.IRC.2017",
      "ORTHOIMAGERY.ORTHOPHOTOS.ORTHO-ASP_PAC2020",
      "ORTHOIMAGERY.ORTHOPHOTOS.ORTHO-EXPRESS.2017",
      "ORTHOIMAGERY.ORTHOPHOTOS.ORTHO-EXPRESS.2019",
      "ORTHOIMAGERY.ORTHOPHOTOS.ORTHO-EXPRESS.2020",
      "ORTHOIMAGERY.ORTHOPHOTOS.SOCLE-ASP.2018",
      "ORTHOIMAGERY.ORTHOPHOTOS.URGENCE.ALEX",
      "ORTHOIMAGERY.ORTHOPHOTOS2000",
      "ORTHOIMAGERY.ORTHOPHOTOS2000-2005",
      "ORTHOIMAGERY.ORTHOPHOTOS2001",
      "ORTHOIMAGERY.ORTHOPHOTOS2002",
      "ORTHOIMAGERY.ORTHOPHOTOS2003",
      "ORTHOIMAGERY.ORTHOPHOTOS2004",
      "ORTHOIMAGERY.ORTHOPHOTOS2005",
      "ORTHOIMAGERY.ORTHOPHOTOS2006",
      "ORTHOIMAGERY.ORTHOPHOTOS2006-2010",
      "ORTHOIMAGERY.ORTHOPHOTOS2007",
      "ORTHOIMAGERY.ORTHOPHOTOS2008",
      "ORTHOIMAGERY.ORTHOPHOTOS2009",
      "ORTHOIMAGERY.ORTHOPHOTOS2010",
      "ORTHOIMAGERY.ORTHOPHOTOS2011",
      "ORTHOIMAGERY.ORTHOPHOTOS2011-2015",
      "ORTHOIMAGERY.ORTHOPHOTOS2012",
      "ORTHOIMAGERY.ORTHOPHOTOS2013",
      "ORTHOIMAGERY.ORTHOPHOTOS2014",
      "ORTHOIMAGERY.ORTHOPHOTOS2015",
      "ORTHOIMAGERY.ORTHOPHOTOS2016",
      "ORTHOIMAGERY.ORTHOPHOTOS2017",
      "ORTHOIMAGERY.ORTHOPHOTOS2018",
      "ORTHOIMAGERY.ORTHOPHOTOS2019",
      "ORTHO-SAT-RAPIDEYE-2011_PYR-JPEG_WLD_WM_20160801",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2012",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2013",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2014",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2015",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2016",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2017",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2018",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2019",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2020",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2021",
      "ORTHOIMAGERY.ORTHO-SAT.PLEIADES.2022",
      "ORTHOIMAGERY.ORTHO-SAT.RAPIDEYE.2010",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2013",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2014",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2015",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2016",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2017",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2018",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2019",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2020",
      "ORTHOIMAGERY.ORTHO-SAT.SPOT.2021",
      "SECUROUTE.TE.1TE",
      "SECUROUTE.TE.2TE48",
      "SECUROUTE.TE.ALL",
      "SECUROUTE.TE.OA",
      "SECUROUTE.TE.PN",
      "SECUROUTE.TE.PND",
      "SECUROUTE.TE.TE120",
      "SECUROUTE.TE.TE72",
      "SECUROUTE.TE.TE94",
      "TRANSPORTNETWORKS.ROADS.DIRECTION",
      "TRANSPORTS.DRONES.RESTRICTIONS"
   )
)

DT::datatable(rgdal_pb_wms)

