% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apicarto_viticole.R
\name{get_apicarto_viticole}
\alias{get_apicarto_viticole}
\title{Apicarto Appellations viticoles}
\usage{
get_apicarto_viticole(x,
                      dTolerance = 0)
}
\arguments{
\item{x}{Object of class \code{sf}. Needs to be located in France.}

\item{dTolerance}{numeric; tolerance parameter. The value of \code{dTolerance}
must be specified in meters, see \code{?sf::st_simplify} for more info.}
}
\value{
Object of class \code{sf}
}
\description{
Implementation of the "Appellations viticoles" module from the
\href{https://apicarto.ign.fr/api/doc/codes-postaux}{IGN's apicarto}. The module
uses a database maintained by FranceAgriMer. This database includes :
appellation d'origine contrôlée (AOC) areas, protected geographical indication areas (IGP)
and wine growing areas without geographical indications (VSIG)
}
\details{
\strong{/!\ For the moment the API cannot returned more than 1000 features.}
}
\examples{
\dontrun{
library(sf)

penmarch <- read_sf(system.file("extdata/penmarch.shp", package = "happign"))

VSIG <- get_apicarto_viticole(penmarch)
}

}
