% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_cf_arima.R
\name{hcp_cf_arima}
\alias{hcp_cf_arima}
\title{Change Finder using ARIMA}
\usage{
hcp_cf_arima(sw_size = NULL)
}
\arguments{
\item{sw_size}{Sliding window size}
}
\value{
\code{hcp_cf_arima} object
}
\description{
Change-point detection is related to event/trend change detection. Change Finder ARIMA detects change points based on deviations relative to ARIMA model \url{doi:10.1109/TKDE.2006.1599387}.
It wraps the ARIMA model presented in the forecast library.
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 6
dataset <- har_examples$example6
head(dataset)

# setting up change point method
model <- hcp_cf_arima()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
