% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_outcomes_are_binary}
\alias{validate_outcomes_are_binary}
\alias{check_outcomes_are_binary}
\title{Ensure that the outcome has binary factors}
\usage{
validate_outcomes_are_binary(outcomes)

check_outcomes_are_binary(outcomes)
}
\arguments{
\item{outcomes}{An object to check.}
}
\value{
\code{validate_outcomes_are_binary()} returns \code{outcomes} invisibly.

\code{check_outcomes_are_binary()} returns a named list of three components,
\code{ok}, \code{bad_cols}, and \code{num_levels}.
}
\description{
validate - asserts the following:
\itemize{
\item \code{outcomes} must have binary factor columns.
}

check - returns the following:
\itemize{
\item \code{ok} A logical. Does the check pass?
\item \code{bad_cols} A character vector. The names of the columns with problems.
\item \code{num_levels} An integer vector. The actual number of levels of the columns
with problems.
}
}
\details{
The expected way to use this validation function is to supply it the
\verb{$outcomes} element of the result of a call to \code{\link[=mold]{mold()}}.
}
\section{Validation}{


hardhat provides validation functions at two levels.
\itemize{
\item \verb{check_*()}:  \emph{check a condition, and return a list}. The list
always contains at least one element, \code{ok}, a logical that specifies if the
check passed. Each check also has check specific elements in the returned
list that can be used to construct meaningful error messages.
\item \verb{validate_*()}: \emph{check a condition, and error if it does not pass}. These
functions call their corresponding check function, and
then provide a default error message. If you, as a developer, want a
different error message, then call the \verb{check_*()} function yourself,
and provide your own validation function.
}
}

\examples{
# Not a binary factor. 0 levels
check_outcomes_are_binary(data.frame(x = 1))

# Not a binary factor. 1 level
check_outcomes_are_binary(data.frame(x = factor("A")))

# All good
check_outcomes_are_binary(data.frame(x = factor(c("A", "B"))))
}
\seealso{
Other validation functions: 
\code{\link{validate_column_names}()},
\code{\link{validate_no_formula_duplication}()},
\code{\link{validate_outcomes_are_factors}()},
\code{\link{validate_outcomes_are_numeric}()},
\code{\link{validate_outcomes_are_univariate}()},
\code{\link{validate_prediction_size}()},
\code{\link{validate_predictors_are_numeric}()}
}
\concept{validation functions}
