% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerlaw.R
\name{dpowerlaw}
\alias{dpowerlaw}
\alias{ppowerlaw}
\alias{qpowerlaw}
\alias{rpowerlaw}
\title{The power law distribution}
\usage{
dpowerlaw(x, shape = 1, scale = 1)

ppowerlaw(q, shape = 1, scale = 1)

qpowerlaw(p, shape = 1, scale = 1)

rpowerlaw(n, shape = 1, scale = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape}{parameter of shape.}

\item{scale}{parameter of scale.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dpowerlaw} gives the density, \code{ppowerlaw} gives the distribution function,
\code{qpowerlaw} gives the quantile function, and \code{rpowerlaw} generates random
deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the power law distribution with shape equal to \code{shape} and scale equal to
\code{scale}.
}
\details{
The density function of the power law distribution is
\deqn{f(t) = \theta a^\theta (a+t)^{-\theta-1}}
where \eqn{\theta} is the shape parameter, and \eqn{a} the scale parameter.
}
