% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWO_hce.R
\name{calcWO.hce}
\alias{calcWO.hce}
\title{Win odds calculation for an hce object}
\usage{
\method{calcWO}{hce}(x, ...)
}
\arguments{
\item{x}{an hce object.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval. It contains the following columns:
\itemize{
\item WO calculated win odds.
\item LCL lower confidence limit.
\item UCL upper confidence limit.
\item SE standard error of the win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
}
}
\description{
Win odds calculation for an hce object
}
\examples{
data(HCE3)
class(HCE3) <- c("hce", "data.frame")
calcWO(HCE3)

}
