% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_leap.R
\name{glm.leap}
\alias{glm.leap}
\title{Posterior of Latent Exchangeability Prior (LEAP)}
\usage{
glm.leap(
  formula,
  family,
  data.list,
  K = 2,
  prob.conc = NULL,
  offset.list = NULL,
  beta.mean = NULL,
  beta.sd = NULL,
  disp.mean = NULL,
  disp.sd = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}.}

\item{data.list}{a list of two \code{data.frame}s giving the current data followed by one historical data set.}

\item{K}{the desired number of classes to identify. Defaults to 2.}

\item{prob.conc}{a scalar or a vector of length \code{K} giving the concentration parameters for Dirichlet prior.
If length == 2, a \code{beta(prob.conc[1], prob.conc[2])} prior is used. If a scalar is provided,
prob.conc will be a vector of repeated elements of the given scalar. Defaults to a vector of 1s.}

\item{offset.list}{a list of matrices giving the offset for current data followed by historical data. For each
matrix, the number of rows corresponds to observations and columns correspond to classes.
Defaults to a list of matrices of 0s.}

\item{beta.mean}{a \verb{p x K} matrix of mean parameters for initial prior on regression coefficients (including
intercept). Defaults to a matrix of 0s.}

\item{beta.sd}{a \verb{p x K} matrix of sd parameters for the initial prior on regression coefficients (including
intercept). Defaults to a matrix of 10s.}

\item{disp.mean}{a scalar or a vector whose dimension is equal to the number of classes (\code{K}) giving the means for
the half-normal hyperpriors on the dispersion parameters. If a scalar is provided, disp.mean will
be a vector of repeated elements of the given scalar. Defaults to a vector of 0s.}

\item{disp.sd}{a scalar or a vector whose dimension is equal to the number of classes (\code{K}) giving the sds for
the half-normal hyperpriors on the dispersion parameters. If a scalar is provided, same as for
disp.mean. Defaults to a vector of 10s.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g. seed, refresh, init).}
}
\value{
The function returns an object of class \code{draws_df} giving posterior samples.
}
\description{
Sample from the posterior distribution of a GLM using the LEAP by Alt et al. (2023).
}
\details{
The LEAP discounts the historical data by identifying the most relevant individuals from the historical data.
It is equivalent to a prior induced by the posterior of a finite mixture model for the historical data set.
}
\examples{
data(actg019)
data(actg036)
# take subset for speed purposes
actg019 = actg019[1:100, ]
actg036 = actg036[1:50, ]
if (instantiate::stan_cmdstan_exists()) {
  glm.leap(
    formula = outcome ~ scale(age) + race + treatment + scale(cd4),
    family = binomial('logit'),
    data.list = list(actg019, actg036),
    K = 2,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
}
}
\references{
Alt, E. M., Chang, X., Jiang, X., Liu, Q., Mo, M., Xia, H. M., and Ibrahim, J. G. (2023). LEAP: The latent exchangeability prior for borrowing information from historical data. arXiv preprint.
}
