% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stsc.R
\name{summary_stsc}
\alias{summary_stsc}
\title{Statistical summary of the STSC-results}
\usage{
summary_stsc(oos_y, oos_benchmark, oos_forecast_stsc)
}
\arguments{
\item{oos_y}{A matrix of dimension `T * 1` or numeric vector of length `T`
containing the out-of-sample observations of the target variable.}

\item{oos_benchmark}{A matrix of dimension `T * 1` or
numeric vector of length `T` containing the
out-of-sample forecasts of an arbitrary benchmark
(i.e. prevailing historical mean).}

\item{oos_forecast_stsc}{A matrix of dimension `T * 1`
or numeric vector of length `T` containing the
out-of-sample forecasts of dsc().}
}
\value{
List that contains:
* (1) the Clark-West-Statistic,
* (2) the Out-of-Sample R2,
* (3) a vector with the CSSED between the STSC-Forecast and the benchmark and
* (4) a list with the MSE of the STSC-Model and the benchmark.
}
\description{
`summary_stsc()` returns a statistical summary
of the results from dsc(). It provides statistical measures
such as Clark-West-Statistic, OOS-R2, Mean-Squared-Error and
Cumulated Sum of Squared-Error-Differences.
}
\examples{
\donttest{

# See example for tvc().

}
}
\references{
Clark, T. E. and West, K. D. (2007) "Approximately normal tests for equal predictive accuracy in nested models."
\emph{Journal of Econometrics}, 138 (1): 291–311.
}
\seealso{
\url{https://github.com/lehmasve/hdflex#readme}
}
\author{
Philipp Adämmer, Sven Lehmann, Rainer Schüssler
}
