% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmu_lasso.R
\name{gmu_lasso}
\alias{gmu_lasso}
\title{Generalized Matrix Uncertainty Lasso}
\usage{
gmu_lasso(
  W,
  y,
  lambda = NULL,
  delta = NULL,
  family = "binomial",
  active_set = TRUE,
  maxit = 1000
)
}
\arguments{
\item{W}{Design matrix, measured with error. Must be a numeric matrix.}

\item{y}{Vector of responses.}

\item{lambda}{Regularization parameter. If not set, lambda.min from
glmnet::cv.glmnet is used.}

\item{delta}{Additional regularization parameter, bounding the measurement
error.}

\item{family}{Character string. Currently "binomial" and "poisson" are
supported.}

\item{active_set}{Logical. Whether or not to use an active set strategy to
speed up coordinate descent algorithm.}

\item{maxit}{Maximum number of iterations of iterative reweighing algorithm.}
}
\value{
An object of class "gmu_lasso".
}
\description{
Generalized Matrix Uncertainty Lasso
}
\examples{
set.seed(1)
# Number of samples
n <- 200
# Number of covariates
p <- 100
# Number of nonzero features
s <- 10
# True coefficient vector
beta <- c(rep(1,s),rep(0,p-s))
# Standard deviation of measurement error
sdU <- 0.2
# True data, not observed
X <- matrix(rnorm(n*p),nrow = n,ncol = p)
# Measured data, with error
W <- X + sdU * matrix(rnorm(n * p), nrow = n, ncol = p)
# Binomial response
y <- rbinom(n, 1, (1 + exp(-X\%*\%beta))**(-1))
# Run the GMU Lasso
fit <- gmu_lasso(W, y, delta = NULL)
print(fit)
plot(fit)
coef(fit)
# Get an elbow plot, in order to choose delta.
plot(fit)


}
\references{
\insertRef{rosenbaum2010}{hdme}

  \insertRef{sorensen2018}{hdme}
}
