% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{createNutsEngine}
\alias{createNutsEngine}
\title{Create a Zigzag-NUTS engine object}
\usage{
createNutsEngine(
  dimension,
  lowerBounds,
  upperBounds,
  seed,
  stepSize,
  mean,
  precision,
  flags = 128L
)
}
\arguments{
\item{dimension}{the dimension of MTN.}

\item{lowerBounds}{a vector specifying the lower bounds.}

\item{upperBounds}{a vector specifying the upper bounds.}

\item{seed}{random seed.}

\item{stepSize}{the base step size for Zigzag-NUTS.}

\item{mean}{the mean vector.}

\item{precision}{the precision matrix.}

\item{flags}{which SIMD instruction set to use. 128 = SSE, 256 = AVX.}
}
\value{
a list whose only element is the Zigzag-NUTS engine object.
}
\description{
Create the C++ object to set up SIMD vectorization for speeding up calculations
for Zigzag-NUTS ("Zigzag-NUTS engine").
}
