% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigzagHMC.R
\name{zigzagHMC}
\alias{zigzagHMC}
\title{Sample from a truncated Gaussian distribution}
\usage{
zigzagHMC(
  n,
  burnin = 0,
  mean,
  cov,
  prec = NULL,
  lowerBounds,
  upperBounds,
  init = NULL,
  step = NULL,
  nutsFlg = FALSE,
  rSeed = 1
)
}
\arguments{
\item{n}{number of samples after burn-in.}

\item{burnin}{number of burn-in samples (default = 0).}

\item{mean}{a d-dimensional mean vector.}

\item{cov}{a d-by-d covariance matrix of the Gaussian distribution. At least one of \code{prec} and \code{cov} should be provided.}

\item{prec}{a d-by-d precision matrix of the Gaussian distribution.}

\item{lowerBounds}{a d-dimensional vector specifying the lower bounds. \code{-Inf} is accepted.}

\item{upperBounds}{a d-dimensional vector specifying the upper bounds. \code{Inf} is accepted.}

\item{init}{a d-dimensional vector of the initial value. \code{init} must satisfy all constraints. If \code{init = NULL}, a random initial value will be used.}

\item{step}{step size for Zigzag-HMC or Zigzag-NUTS (if \code{nutsFlg = TRUE}). Default value is the empirically optimal choice: sqrt(2)(lambda)^(-1/2) for Zigzag-HMC and 0.1(lambda)^(-1/2) for Zigzag-NUTS, where lambda is the minimal eigenvalue of the precision matrix.}

\item{nutsFlg}{logical. If \code{TRUE} the No-U-Turn sampler will be used (Zigzag-NUTS).}

\item{rSeed}{random seed (default = 1).}
}
\value{
an (n + burnin)*d matrix of samples. The first \code{burnin} samples are from the user specified warm-up iterations.
}
\description{
Generate MCMC samples from a d-dimensional truncated Gaussian distribution with element-wise truncations using the Zigzag Hamiltonian Monte Carlo sampler (Zigzag-HMC).
}
\examples{
set.seed(1)
d <- 10
A <- matrix(runif(d^2)*2-1, ncol=d)
covMat <- t(A) \%*\% A
initial <- rep(1, d)
results <- zigzagHMC(n = 1000, burnin = 1000, mean = rep(0, d), cov = covMat,
lowerBounds = rep(0, d), upperBounds = rep(Inf, d))

}
\references{
\insertRef{nishimura2021hamiltonian}{hdtg}

\insertRef{nishimura2020discontinuous}{hdtg}
}
