% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{calculateSDChanges}
\alias{calculateSDChanges}
\title{Calculate std deviation up/down for each numeric field in row}
\usage{
calculateSDChanges(dfOriginal, rowNum, numColLeaveOut, sizeOfSDPerturb = 0.5)
}
\arguments{
\item{dfOriginal}{Data frame from Error in as.double(y) : 
cannot coerce type 'S4' to vector of type 'double' which we'll draw a row for alt-scenarios}

\item{rowNum}{Row in dfOriginal that we'll create alt-scenarios for}

\item{numColLeaveOut}{Numeric columns to leave out of alterlative scenarios}

\item{sizeOfSDPerturb}{Default is 0.5. Shrink or expand SD drop/addition}
}
\description{
Add/subtract each numeric col (for each row) by std dev, such
that we have a new alternate data frame
}
\examples{
df <- data.frame(a=c(1,2,3),
                 b=c('m','f','m'),
                 c=c(0.7,1.4,2.4),
                 d=c(100,250,200),
                 e=c(400,500,505))


dfResult <- calculateSDChanges(dfOriginal = df,
                               rowNum = 2,
                               numColLeaveOut = c('d','e'),
                               sizeOfSDPerturb = 0.5)
dfResult
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
