% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{selectData}
\alias{selectData}
\title{Pull data into R via an ODBC connection}
\usage{
selectData(MSSQLConnectionString = NULL, query, SQLiteFileName = NULL,
  randomize = FALSE, connectionString = NULL)
}
\arguments{
\item{MSSQLConnectionString}{A string specifying the driver, server, 
database, and whether Windows Authentication will be used. Omit if using 
SQLite.}

\item{query}{The SQL query (in ticks or quotes).}

\item{SQLiteFileName}{A string. If your database type is SQLite, here one 
specifies the database file to query from.}

\item{randomize}{Boolean that dictates whether returned rows are randomized}

\item{connectionString}{DEPRECATED. Use MSSQLConnectionString}
}
\value{
df A data frame containing the selected rows
}
\description{
Select data from an ODBC database and return the results as
a data frame.
}
\examples{

\donttest{
# This example is specific to SQL Server

# To instead pull data from Oracle see here 
# https://cran.r-project.org/web/packages/ROracle/ROracle.pdf
# To pull data from MySQL see here 
# https://cran.r-project.org/web/packages/RMySQL/RMySQL.pdf
# To pull data from Postgres see here 
# https://cran.r-project.org/web/packages/RPostgreSQL/RPostgreSQL.pdf

connectionString <- '
  driver={SQL Server};
  server=localhost;
  database=SAM;
  trustedConnection=true
  '

query <- '
  SELECT
    A1CNBR
  FROM SAM.dbo.HCRDiabetesClinical
  '

df <- selectData(connectionString, query)
head(df)
}

# SQLite example
query <- '
  SELECT *
  FROM HCRDiabetesClinical
  '
# Loads sample database; replace with your own SQLite db file
sqliteFile <- system.file("extdata",
                          "unit-test.sqlite",
                          package = "healthcareai")

df <- selectData(query = query, 
                 SQLiteFileName = sqliteFile)
head(df)      
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
