% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-LIME-like.R
\name{findBestAlternateScenarios}
\alias{findBestAlternateScenarios}
\title{Find most biggest drop in predictive probability across alternate features}
\usage{
findBestAlternateScenarios(dfAlternateFeat, originalRow, predictionVector,
  predictionOriginal)
}
\arguments{
\item{dfAlternateFeat}{Data frame of alternate feature values}

\item{originalRow}{Row from original data frame upon which alternates are
based}

\item{predictionVector}{List of alternate predictions}

\item{predictionOriginal}{Scalar representing original prediction for
row, without alternative scenario}
}
\description{
Compare each alternate probability prediction and determine
which ones are lowest compared to the original; return the top three column
names that lead to the biggest drop and their target value.
}
\examples{
library(caret)
df <- data.frame(a = c(1,2,3,1),
                 b = c('m','f','m','m'),
                 c = c(0.7,1.4,2.4,2.0),
                 d = c(100,250,200,150))

y <- c('y','n','y','n')

dfAlt <- calculateSDChanges(df = df,
                            rowNum = 2,
                            sizeOfSDPerturb = 0.5,
                            numColLeaveOut = 'd')

glmOb <- train(x = df,y = y,method = 'glm',family = 'binomial')

originalPred <- predict(object = glmOb,
                        newdata = df[4,],
                        type = 'prob')

alternatePred <- calulcateAlternatePredictions(df = dfAlt,
                                               modelObj = glmOb,
                                               type = 'lasso',
                                               removeCols = 'AlteredCol')

dfResult <- findBestAlternateScenarios(dfAlternateFeat = dfAlt,
                                       originalRow = df[4,],
                                       predictionVector = as.numeric(alternatePred),
                                       predictionOriginal = originalPred[[2]])

dfResult
}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}}
}
