% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data_utils.R
\name{convert_date_cols}
\alias{convert_date_cols}
\title{Convert character date columns to dates}
\usage{
convert_date_cols(d)
}
\arguments{
\item{d}{A dataframe or tibble containing data to try to convert to dates.}
}
\value{
A tibble containing the converted date columns. If no columns needed
  conversion, the original data will be returned.
}
\description{
This function is called in \code{\link{prep_data}} and so
  shouldn't usually need to be called directly. It tries to convert columns
  ending in "DTS" to type Date. It makes a best guess at the format and
  return a more standard one if possible. Times are be removed.
}
\examples{
d <- tibble::tibble(a_DTS = c("2018-3-25", "2018-3-25"),
                    b_nums = c(2, 4),
                    c_DTS = c("03-01-2018", "03-07-2018"),
                    d_chars = c("a", "b"),
                    e_date = lubridate::mdy(c("3-25-2018", "3-25-2018")))
convert_date_cols(d)
}
