% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{save_models}
\alias{save_models}
\alias{load_models}
\title{Save models to disk and load models from disk}
\usage{
save_models(x, filename = "models.RDS")

load_models(filename)
}
\arguments{
\item{x}{model_list object}

\item{filename}{File path to save model to or read model from, e.g.
"models/my_models.RDS". Default for \code{save_models} is "models.RDS" in
the working directory (\code{getwd()}). Default for \code{load_models} is
to open a dialog box from which a file can be selected, in which case a
message will issued with code to load the same file without interactivity.}
}
\value{
\code{load_models} returns the model_list which can be assigned to
  any variable name
}
\description{
Note that model objects contain training data, except columns
  ignored (patient_id in the example below). Therefore, if there is PHI in
  the training data, the saved model object must be treated as PHI.
  \code{save_models} issues a message saying as much.
}
\examples{
\dontrun{
m <- machine_learn(pima_diabetes, patient_id, outcome = diabetes)
save_models(m, "diabetes_models.RDS")
# Restart R, move RDS file to another computer, etc.
m2 <- load_models("diabetes_models.RDS")
all.equal(m, m2)
}
}
