% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{plot.interpret}
\alias{plot.interpret}
\title{Plot regularized model coefficients}
\usage{
\method{plot}{interpret}(x, include_intercept = FALSE, max_char = 40,
  title, caption, font_size = 11, point_size = 3, print = TRUE, ...)
}
\arguments{
\item{x}{A \code{interpret} object or a data frame with columns "variable"
and "coefficient"}

\item{include_intercept}{If FALSE (default) the intercept estimate will not
be plotted}

\item{max_char}{Maximum length of variable names to leave untruncated.
Default = 40; use \code{Inf} to prevent truncation. Variable names longer
than this will be truncated to leave the beginning and end of each variable
name, bridged by " ... ".}

\item{title}{Plot title. NULL for no title; character for custom title. If
left blank contains the model class and outcome variable}

\item{caption}{Plot caption, appears in lower-right. NULL for no caption;
character for custom caption. If left blank the caption will contain info
including the hyperparameter values of the model used by
\code{\link{interpret}} to determine coefficient estimates.}

\item{font_size}{Relative size of all fonts in plot, default = 11}

\item{point_size}{Size of dots, default = 3}

\item{print}{Print the plot? Default = TRUE}

\item{...}{Unused}
}
\value{
A ggplot object, invisibly.
}
\description{
Plot regularized model coefficients
}
\examples{
machine_learn(mtcars, outcome = mpg, models = "glm", tune = FALSE) \%>\%
  interpret() \%>\%
  plot(font_size = 14)
}
\seealso{
\code{\link{interpret}}
}
